/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\bJ\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0006\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \t*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b \t*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \t*\b\u0012\u0002\b\u0003\u0018\u00010\b0\b\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/NoDeclarationDescriptorsChecker;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkedQuickFixClasses", "", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "", "check", "", "quickFixClass", "checkType", "type", "Ljava/lang/reflect/Type;", "field", "Ljava/lang/reflect/Field;", "kotlin.core"})
final class NoDeclarationDescriptorsChecker {
    private static final Logger LOG;
    private static final Set<Class<?>> checkedQuickFixClasses;
    @NotNull
    public static final NoDeclarationDescriptorsChecker INSTANCE;

    public final void check(@NotNull Class<?> quickFixClass) {
        block2: {
            int n;
            Intrinsics.checkNotNullParameter(quickFixClass, (String)"quickFixClass");
            if (!checkedQuickFixClasses.add(quickFixClass)) {
                return;
            }
            Field[] fieldArray = quickFixClass.getDeclaredFields();
            int n2 = fieldArray.length;
            for (n = 0; n < n2; ++n) {
                Field field;
                Field field2 = field = fieldArray[n];
                Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"field");
                Type type = field2.getGenericType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"field.genericType");
                this.checkType(type, field);
            }
            Class<?> clazz = quickFixClass.getSuperclass();
            if (clazz == null) break block2;
            Class<?> clazz2 = clazz;
            n = 0;
            boolean bl = false;
            Class<?> it = clazz2;
            boolean bl2 = false;
            INSTANCE.check(it);
        }
    }

    private final void checkType(Type type, Field field) {
        block6: {
            Type type2;
            block8: {
                block7: {
                    block5: {
                        type2 = type;
                        if (!(type2 instanceof Class)) break block5;
                        if (DeclarationDescriptor.class.isAssignableFrom((Class)type) || KotlinType.class.isAssignableFrom((Class)type)) {
                            StringBuilder stringBuilder = new StringBuilder().append("QuickFix class ");
                            Class<?> clazz = field.getDeclaringClass();
                            Intrinsics.checkNotNullExpressionValue(clazz, (String)"field.declaringClass");
                            LOG.error(stringBuilder.append(clazz.getName()).append(" contains field ").append(field.getName()).append(" that holds ").append(((Class)type).getSimpleName()).append(". ").append("This leads to holding too much memory through this quick-fix instance. ").append("Possible solution can be wrapping it using KotlinIntentionActionFactoryWithDelegate.").toString());
                        }
                        if (!IntentionAction.class.isAssignableFrom((Class)type)) break block6;
                        this.check((Class)type);
                        break block6;
                    }
                    if (!(type2 instanceof GenericArrayType)) break block7;
                    Type type3 = ((GenericArrayType)type).getGenericComponentType();
                    Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"type.genericComponentType");
                    this.checkType(type3, field);
                    break block6;
                }
                if (!(type2 instanceof ParameterizedType)) break block8;
                Type type4 = ((ParameterizedType)type).getRawType();
                if (type4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                }
                if (!Collection.class.isAssignableFrom((Class)type4)) break block6;
                Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"type.actualTypeArguments");
                Type[] $this$forEach$iv = typeArray;
                boolean $i$f$forEach = false;
                Type[] typeArray2 = $this$forEach$iv;
                int n = typeArray2.length;
                for (int j = 0; j < n; ++j) {
                    Type element$iv;
                    Type it = element$iv = typeArray2[j];
                    boolean bl = false;
                    Type type5 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"it");
                    INSTANCE.checkType(type5, field);
                }
                break block6;
            }
            if (type2 instanceof WildcardType) {
                Type[] typeArray = ((WildcardType)type).getUpperBounds();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"type.upperBounds");
                Type[] $this$forEach$iv = typeArray;
                boolean $i$f$forEach = false;
                Type[] typeArray3 = $this$forEach$iv;
                int n = typeArray3.length;
                for (int j = 0; j < n; ++j) {
                    Type element$iv;
                    Type it = element$iv = typeArray3[j];
                    boolean bl = false;
                    Type type6 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)type6, (String)"it");
                    INSTANCE.checkType(type6, field);
                }
            }
        }
    }

    private NoDeclarationDescriptorsChecker() {
    }

    static {
        NoDeclarationDescriptorsChecker noDeclarationDescriptorsChecker;
        INSTANCE = noDeclarationDescriptorsChecker = new NoDeclarationDescriptorsChecker();
        Logger logger = Logger.getInstance(NoDeclarationDescriptorsChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(NoDec\u2026ptorsChecker::class.java)");
        LOG = logger;
        checkedQuickFixClasses = Collections.synchronizedSet(new HashSet());
    }
}

