/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.project.CacheUtilKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModelInfosCache;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.LibraryWrapper;
import org.jetbrains.kotlin.idea.caches.project.ModuleInfosFromIdeaModelKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.PlatformModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.util.IjPlatformUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0011\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\r\u001a\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0003*\u00020\u0018H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0000\u001a\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0003H\u0000\u001a\f\u0010\u001e\u001a\u00020\u001f*\u00020\u0018H\u0002\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006 "}, d2={"allRootUrls", "", "", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "getAllRootUrls", "(Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;)Ljava/util/Set;", "collectModuleInfosFromIdeaModel", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModelInfosCache;", "project", "Lcom/intellij/openapi/project/Project;", "getAllProjectSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "()[Lcom/intellij/openapi/projectRoots/Sdk;", "getIdeaModelInfosCache", "getModuleInfosFromIdeaModel", "", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "mergePlatformModules", "allModules", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "asLibraryEx", "Lcom/intellij/openapi/roots/libraries/Library;", "hasEqualRoots", "", "other", "rootBasedHashCode", "", "wrap", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryWrapper;", "kotlin.core"})
public final class ModuleInfosFromIdeaModelKt {
    @NotNull
    public static final List<IdeaModuleInfo> getModuleInfosFromIdeaModel(@NotNull Project project, @Nullable TargetPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        IdeaModelInfosCache ideaModelInfosCache = ModuleInfosFromIdeaModelKt.getIdeaModelInfosCache(project);
        return platform != null ? ideaModelInfosCache.forPlatform(platform) : ideaModelInfosCache.allModules();
    }

    public static /* synthetic */ List getModuleInfosFromIdeaModel$default(Project project, TargetPlatform targetPlatform, int n, Object object) {
        if ((n & 2) != 0) {
            targetPlatform = null;
        }
        return ModuleInfosFromIdeaModelKt.getModuleInfosFromIdeaModel(project, targetPlatform);
    }

    @NotNull
    public static final IdeaModelInfosCache getIdeaModelInfosCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (IdeaModelInfosCache)CacheUtilKt.cacheInvalidatingOnRootModifications((Project)project, (Function0)((Function0)new Function0<IdeaModelInfosCache>(project){
            final /* synthetic */ Project $project;

            @NotNull
            public final IdeaModelInfosCache invoke() {
                return ModuleInfosFromIdeaModelKt.access$collectModuleInfosFromIdeaModel(this.$project);
            }
            {
                this.$project = project;
                super(0);
            }
        }));
    }

    @NotNull
    public static final LibraryEx asLibraryEx(@NotNull Library $this$asLibraryEx) {
        Intrinsics.checkNotNullParameter((Object)$this$asLibraryEx, (String)"$this$asLibraryEx");
        boolean bl = $this$asLibraryEx instanceof LibraryEx;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Library '" + $this$asLibraryEx.getName() + "' does not implement LibraryEx which is not expected";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return (LibraryEx)$this$asLibraryEx;
    }

    private static final LibraryWrapper wrap(Library $this$wrap) {
        return new LibraryWrapper(ModuleInfosFromIdeaModelKt.asLibraryEx($this$wrap));
    }

    @NotNull
    public static final Set<String> getAllRootUrls(@NotNull LibraryEx $this$allRootUrls) {
        Intrinsics.checkNotNullParameter((Object)$this$allRootUrls, (String)"$this$allRootUrls");
        boolean bl = false;
        Set set = new LinkedHashSet();
        boolean bl2 = false;
        boolean bl3 = false;
        Set $this$apply = set;
        boolean bl4 = false;
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            Collection collection = $this$apply;
            Object[] objectArray = $this$allRootUrls.getRootProvider().getUrls(orderRootType);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootProvider.getUrls(orderRootType)");
            CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
        }
        return set;
    }

    public static final boolean hasEqualRoots(@NotNull LibraryEx $this$hasEqualRoots, @NotNull LibraryEx other) {
        Intrinsics.checkNotNullParameter((Object)$this$hasEqualRoots, (String)"$this$hasEqualRoots");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual(ModuleInfosFromIdeaModelKt.getAllRootUrls($this$hasEqualRoots), ModuleInfosFromIdeaModelKt.getAllRootUrls(other)) ^ true) {
            return false;
        }
        Object[] objectArray = $this$hasEqualRoots.getExcludedRootUrls();
        Object[] objectArray2 = other.getExcludedRootUrls();
        boolean bl = false;
        return Arrays.equals(objectArray, objectArray2);
    }

    public static final int rootBasedHashCode(@NotNull LibraryEx $this$rootBasedHashCode) {
        Intrinsics.checkNotNullParameter((Object)$this$rootBasedHashCode, (String)"$this$rootBasedHashCode");
        return 31 + ((Object)ModuleInfosFromIdeaModelKt.getAllRootUrls($this$rootBasedHashCode)).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    private static final IdeaModelInfosCache collectModuleInfosFromIdeaModel(Project project) {
        Map map2;
        void $this$associateWith$iv;
        void $this$flatMapTo$iv$iv3;
        Object object;
        Object destination$iv$iv;
        void $this$flatMapTo$iv$iv2;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Object[] objectArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ModuleManager.getInstance(project).modules");
        List ideaModules = ArraysKt.toList((Object[])objectArray);
        Iterable $this$flatMap$iv = ideaModules;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Module it = (Module)element$iv$iv;
            boolean bl = false;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)it);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(it)");
            OrderEntry[] orderEntryArray = moduleRootManager.getOrderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"ModuleRootManager.getInstance(it).orderEntries");
            Object $this$filterIsInstance$iv = orderEntryArray;
            boolean $i$f$filterIsInstance = false;
            OrderEntry[] orderEntryArray2 = $this$filterIsInstance$iv;
            destination$iv$iv = (OrderEntry[])new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)item$iv$iv;
                Object object2 = destination$iv$iv;
                boolean bl2 = false;
                Library library = it2.getLibrary();
                object = library != null ? ModuleInfosFromIdeaModelKt.wrap(library) : null;
                object2.add(object);
            }
            Iterable list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set ideaLibraries = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv2)));
        Iterable $this$flatMap$iv2 = ideaModules;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv2 = $this$flatMap$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv3) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Module it = (Module)element$iv$iv;
            boolean bl = false;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)it);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(it)");
            OrderEntry[] orderEntryArray = moduleRootManager.getOrderEntries();
            Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"ModuleRootManager.getInstance(it).orderEntries");
            Object $this$filterIsInstance$iv = orderEntryArray;
            boolean $i$f$filterIsInstance = false;
            destination$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv3 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv3 instanceof JdkOrderEntry)) continue;
                destination$iv$iv4.add(element$iv$iv3);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv4;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                JdkOrderEntry bl2 = (JdkOrderEntry)item$iv$iv;
                object = destination$iv$iv4;
                boolean bl3 = false;
                Sdk sdk = it3.getJdk();
                object.add(sdk);
            }
            Iterable list$iv$iv = (List)destination$iv$iv4;
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List sdksFromModulesDependencies = (List)destination$iv$iv3;
        $this$flatMap$iv2 = MultiMap.create();
        $i$f$flatMap2 = false;
        boolean $this$flatMapTo$iv$iv3 = false;
        Iterable moduleInfosByModules = $this$flatMap$iv2;
        boolean bl = false;
        for (Module module : ideaModules) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            Module module2 = module;
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
            moduleInfosByModules.putValues(module, IdeaModuleInfosKt.correspondingModuleInfos(module2));
        }
        Object object3 = Unit.INSTANCE;
        Iterable iterable2 = $this$flatMap$iv2;
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"MultiMap.create<Module, \u2026)\n            }\n        }");
        $this$flatMap$iv2 = MultiMap.create();
        $i$f$flatMap2 = false;
        $this$flatMapTo$iv$iv3 = false;
        moduleInfosByModules = $this$flatMap$iv2;
        object3 = iterable2;
        boolean bl4 = false;
        for (LibraryWrapper libraryWrapper : ideaLibraries) {
            void libraryInfosByLibraries;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            libraryInfosByLibraries.putValues((Object)libraryWrapper.getLibrary(), (Collection)IdeaModuleInfosKt.createLibraryInfo(project, (Library)libraryWrapper.getLibrary()));
        }
        Object object4 = Unit.INSTANCE;
        Iterable iterable3 = $this$flatMap$iv2;
        Intrinsics.checkNotNullExpressionValue((Object)iterable3, (String)"MultiMap.create<Library,\u2026)\n            }\n        }");
        $this$flatMap$iv2 = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)sdksFromModulesDependencies, (Object[])ModuleInfosFromIdeaModelKt.getAllProjectSdks())));
        object4 = iterable3;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Sdk list$iv$iv = (Sdk)element$iv$iv;
            Object object5 = element$iv$iv;
            map2 = result$iv;
            boolean bl5 = false;
            SdkInfo sdkInfo = new SdkInfo(project, (Sdk)it);
            map2.put(object5, sdkInfo);
        }
        Map map3 = map2 = (Map)result$iv;
        Object object6 = object4;
        Object object7 = object3;
        return new IdeaModelInfosCache((MultiMap<Module, ModuleSourceInfo>)object7, (MultiMap<Library, LibraryInfo>)object6, map3);
    }

    /*
     * Unable to fully structure code
     */
    private static final List<IdeaModuleInfo> mergePlatformModules(List<? extends ModuleSourceInfo> allModules, TargetPlatform platform) {
        if (TargetPlatformKt.isCommon((TargetPlatform)platform)) {
            return allModules;
        }
        $this$flatMap$iv = allModules;
        $i$f$flatMap = false;
        var5_5 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            module = (ModuleSourceInfo)element$iv$iv;
            $i$a$-flatMap-ModuleInfosFromIdeaModelKt$mergePlatformModules$platformModules$1 = false;
            if (!Intrinsics.areEqual((Object)module.getPlatform(), (Object)platform)) ** GOTO lbl-1000
            var12_16 = module.getExpectedBy();
            var13_18 = false;
            if (var12_16.isEmpty() == false) {
                v0 = CollectionsKt.listOf((Object)TuplesKt.to((Object)module, module.getExpectedBy()));
            } else lbl-1000:
            // 2 sources

            {
                v0 = CollectionsKt.emptyList();
            }
            list$iv$iv = v0;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Pair)item$iv$iv;
            var14_20 = destination$iv$iv;
            $i$a$-map-ModuleInfosFromIdeaModelKt$mergePlatformModules$platformModules$2 = false;
            var12_16 = (ModuleSourceInfo)$dstr$module$expectedBys.component1();
            expectedBys = (List)$dstr$module$expectedBys.component2();
            var15_21 = new PlatformModuleInfo((ModuleSourceInfo)module, CollectionsKt.toList((Iterable)TypeUtilsKt.closure((Collection)expectedBys, (boolean)true, (Function1)mergePlatformModules.platformModules.2.1.INSTANCE)));
            var14_20.add(var15_21);
        }
        platformModules = (List)destination$iv$iv;
        $i$f$map = platformModules;
        var14_20 = allModules;
        $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (PlatformModuleInfo)element$iv$iv;
            $i$a$-flatMap-ModuleInfosFromIdeaModelKt$mergePlatformModules$rest$1 = false;
            list$iv$iv = it.getContainedModules();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var15_21 = (List)destination$iv$iv;
        rest = CollectionsKt.minus(var14_20, (Iterable)((Iterable)var15_21));
        return CollectionsKt.plus((Collection)rest, (Iterable)platformModules);
    }

    @NotNull
    public static final Sdk[] getAllProjectSdks() {
        Sdk[] sdkArray = IjPlatformUtil.getProjectJdkTableSafe().getAllJdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getProjectJdkTableSafe().allJdks");
        return sdkArray;
    }

    public static final /* synthetic */ List access$mergePlatformModules(List allModules, TargetPlatform platform) {
        return ModuleInfosFromIdeaModelKt.mergePlatformModules(allModules, platform);
    }

    public static final /* synthetic */ IdeaModelInfosCache access$collectModuleInfosFromIdeaModel(Project project) {
        return ModuleInfosFromIdeaModelKt.collectModuleInfosFromIdeaModel(project);
    }
}

