/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.InvalidModuleException;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.psi.KtElement;

public final class KotlinDescriptorIconProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.idea.KotlinDescriptorIconProvider");

    private KotlinDescriptorIconProvider() {
    }

    @Nullable
    public static Icon getIcon(@NotNull DeclarationDescriptor descriptor, @Nullable PsiElement declaration, @Iconable.IconFlags int flags) {
        if (descriptor == null) {
            KotlinDescriptorIconProvider.$$$reportNull$$$0(0);
        }
        if (declaration != null && !(declaration instanceof KtElement)) {
            return declaration.getIcon(flags);
        }
        Icon result = KotlinDescriptorIconProvider.getBaseIcon(descriptor);
        if ((flags & 1) > 0) {
            RowIcon rowIcon = new RowIcon(2);
            rowIcon.setIcon(result, 0);
            rowIcon.setIcon(KotlinDescriptorIconProvider.getVisibilityIcon(descriptor), 1);
            result = rowIcon;
        }
        return result;
    }

    private static Icon getVisibilityIcon(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            KotlinDescriptorIconProvider.$$$reportNull$$$0(1);
        }
        if (descriptor instanceof DeclarationDescriptorWithVisibility) {
            DeclarationDescriptorWithVisibility descriptorWithVisibility = (DeclarationDescriptorWithVisibility)descriptor;
            DescriptorVisibility visibility2 = descriptorWithVisibility.getVisibility().normalize();
            if (visibility2 == DescriptorVisibilities.PUBLIC) {
                return PlatformIcons.PUBLIC_ICON;
            }
            if (visibility2 == DescriptorVisibilities.PROTECTED) {
                return PlatformIcons.PROTECTED_ICON;
            }
            if (DescriptorVisibilities.isPrivate((DescriptorVisibility)visibility2)) {
                return PlatformIcons.PRIVATE_ICON;
            }
            if (visibility2 == DescriptorVisibilities.INTERNAL) {
                return PlatformIcons.PACKAGE_LOCAL_ICON;
            }
        }
        return null;
    }

    private static Modality getModalitySafe(@NotNull MemberDescriptor descriptor) {
        if (descriptor == null) {
            KotlinDescriptorIconProvider.$$$reportNull$$$0(2);
        }
        try {
            return descriptor.getModality();
        }
        catch (InvalidModuleException ex) {
            return Modality.FINAL;
        }
    }

    private static Icon getBaseIcon(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            KotlinDescriptorIconProvider.$$$reportNull$$$0(3);
        }
        if (descriptor instanceof PackageFragmentDescriptor || descriptor instanceof PackageViewDescriptor) {
            return PlatformIcons.PACKAGE_ICON;
        }
        if (descriptor instanceof FunctionDescriptor) {
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
            if (functionDescriptor.getExtensionReceiverParameter() != null) {
                return Modality.ABSTRACT == KotlinDescriptorIconProvider.getModalitySafe((MemberDescriptor)functionDescriptor) ? KotlinIcons.ABSTRACT_EXTENSION_FUNCTION : KotlinIcons.EXTENSION_FUNCTION;
            }
            if (descriptor.getContainingDeclaration() instanceof ClassDescriptor) {
                return Modality.ABSTRACT == KotlinDescriptorIconProvider.getModalitySafe((MemberDescriptor)functionDescriptor) ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
            }
            return KotlinIcons.FUNCTION;
        }
        if (descriptor instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
            switch (classDescriptor.getKind()) {
                case INTERFACE: {
                    return KotlinIcons.INTERFACE;
                }
                case ENUM_CLASS: {
                    return KotlinIcons.ENUM;
                }
                case ENUM_ENTRY: {
                    return KotlinIcons.ENUM;
                }
                case ANNOTATION_CLASS: {
                    return KotlinIcons.ANNOTATION;
                }
                case OBJECT: {
                    return KotlinIcons.OBJECT;
                }
                case CLASS: {
                    return Modality.ABSTRACT == KotlinDescriptorIconProvider.getModalitySafe((MemberDescriptor)classDescriptor) ? KotlinIcons.ABSTRACT_CLASS : KotlinIcons.CLASS;
                }
            }
            LOG.warn("No icon for descriptor: " + descriptor);
            return null;
        }
        if (descriptor instanceof ValueParameterDescriptor) {
            return KotlinIcons.PARAMETER;
        }
        if (descriptor instanceof LocalVariableDescriptor) {
            return ((VariableDescriptor)descriptor).isVar() ? KotlinIcons.VAR : KotlinIcons.VAL;
        }
        if (descriptor instanceof PropertyDescriptor) {
            return ((VariableDescriptor)descriptor).isVar() ? KotlinIcons.FIELD_VAR : KotlinIcons.FIELD_VAL;
        }
        if (descriptor instanceof TypeParameterDescriptor) {
            return PlatformIcons.CLASS_ICON;
        }
        if (descriptor instanceof TypeAliasDescriptor) {
            return KotlinIcons.TYPE_ALIAS;
        }
        LOG.warn("No icon for descriptor: " + descriptor);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "descriptor";
        objectArray2[1] = "org/jetbrains/kotlin/idea/KotlinDescriptorIconProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVisibilityIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getModalitySafe";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBaseIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

