/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.resources;

import com.google.gct.idea.resources.RepositoryItem;
import com.google.gct.idea.resources.RepositoryModelItem;
import com.google.gct.idea.resources.ResourceEmptyModelItem;
import com.google.gct.idea.resources.ResourceErrorModelItem;
import com.google.gct.idea.resources.ResourceLoadingModelItem;
import com.google.gct.idea.resources.ResourceSelectorEmptyItem;
import com.google.gct.idea.resources.ResourceSelectorErrorItem;
import com.google.gct.idea.resources.ResourceSelectorLoadingItem;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class RepositorySelectorRenderer
extends DefaultTreeCellRenderer {
    private RepositoryItem repositoryItem;
    private ResourceSelectorLoadingItem loadingItem;
    private ResourceSelectorEmptyItem emptyItem;
    private ResourceSelectorErrorItem errorItem;

    public RepositorySelectorRenderer() {
        DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();
        this.repositoryItem = new RepositoryItem();
        this.loadingItem = new ResourceSelectorLoadingItem(defaultRenderer.getBackgroundNonSelectionColor(), defaultRenderer.getTextNonSelectionColor());
        this.emptyItem = new ResourceSelectorEmptyItem();
        this.errorItem = new ResourceSelectorErrorItem((Color)JBColor.RED);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof RepositoryModelItem) {
            this.repositoryItem.setText(((RepositoryModelItem)value).getRepositoryId());
            return this.repositoryItem;
        }
        if (value instanceof ResourceLoadingModelItem) {
            this.loadingItem.snap();
            return this.loadingItem;
        }
        if (value instanceof ResourceEmptyModelItem) {
            this.emptyItem.setText(((ResourceEmptyModelItem)value).getMessage());
            return this.emptyItem;
        }
        if (value instanceof ResourceErrorModelItem) {
            this.errorItem.setText(((ResourceErrorModelItem)value).getErrorMessage());
            return this.errorItem;
        }
        return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }
}

