/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.gct.idea.resources.ProjectRepositoriesModelItem;
import com.google.gct.idea.resources.RepositoryModelItem;
import com.google.gct.idea.resources.RepositorySelectorRenderer;
import com.google.gct.idea.resources.ResourceLoadingModelItem;
import com.google.gct.idea.ui.CustomizableComboBox;
import com.google.gct.idea.ui.CustomizableComboBoxPopup;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import icons.GoogleCloudToolsIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public class RepositorySelector
extends CustomizableComboBox
implements CustomizableComboBoxPopup {
    private static final Logger logger = Logger.getInstance(RepositorySelector.class);
    private static final int SELECTOR_HEIGHT = 140;
    private static final int SELECTOR_WIDTH = 400;
    private static final String PANETHEON_CREATE_REPO_URL_PREFIX = "https://console.cloud.google.com/code/develop/repo?project=";
    private JBPopup popup;
    private JPanel panel;
    private ProjectRepositoriesModelItem repositories;
    private String cloudProject;
    private CredentialedUser user;
    private boolean canCreateRepository;

    public RepositorySelector(@Nullable String cloudProject, @Nullable CredentialedUser user, boolean canCreateRepository) {
        this.cloudProject = cloudProject;
        this.user = user;
        this.canCreateRepository = canCreateRepository;
        this.getTextField().getEmptyText().setText(GctBundle.message("cloud.repository.selector.placeholder.text", new Object[0]));
    }

    @Nullable
    public String getSelectedRepository() {
        if (StringUtil.isEmpty((String)this.getText()) || this.repositories == null) {
            return null;
        }
        Enumeration<TreeNode> repos = this.repositories.children();
        while (repos.hasMoreElements()) {
            TreeNode repo = repos.nextElement();
            if (!(repo instanceof RepositoryModelItem) || !this.getText().equals(((RepositoryModelItem)repo).getRepositoryId())) continue;
            return this.getText();
        }
        return null;
    }

    public void setCloudProject(String cloudProject) {
        this.cloudProject = cloudProject;
    }

    public void setUser(CredentialedUser user) {
        this.user = user;
    }

    public void loadRepositories() {
        this.loadRepositories(null);
    }

    public void loadRepositories(@Nullable Runnable onComplete) {
        if (this.user == null || this.cloudProject == null) {
            return;
        }
        if (this.repositories == null) {
            this.repositories = new ProjectRepositoriesModelItem();
        }
        this.repositories.loadRepositories(this.cloudProject, this.user, onComplete);
    }

    @Override
    public void showPopup(RelativePoint showTarget) {
        if (this.user != null) {
            if (this.popup == null || this.popup.isDisposed()) {
                this.panel = new RepositoryPanel();
                ComponentPopupBuilder popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.panel, null);
                this.popup = popupBuilder.createPopup();
            }
            if (!this.popup.isVisible()) {
                this.popup.show(showTarget);
            }
        } else {
            this.panel = new ProjectNotSelectedPanel();
            ComponentPopupBuilder popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.panel, null);
            this.popup = popupBuilder.createPopup();
            this.popup.show(showTarget);
        }
    }

    @Override
    public void hidePopup() {
        if (this.isPopupVisible()) {
            this.popup.closeOk(null);
        }
    }

    @Override
    public boolean isPopupVisible() {
        return this.popup != null && !this.popup.isDisposed() && this.popup.isVisible();
    }

    @Override
    protected CustomizableComboBoxPopup getPopup() {
        return this;
    }

    private int getPopupWidth() {
        int actualWidth = this.getTextField().getWidth();
        return Math.max(400, actualWidth);
    }

    @Override
    protected int getPreferredPopupHeight() {
        return 140;
    }

    @VisibleForTesting
    public JPanel getPanel() {
        return this.panel;
    }

    @VisibleForTesting
    public ProjectRepositoriesModelItem getRepositories() {
        return this.repositories;
    }

    @VisibleForTesting
    public class RepositoryPanel
    extends JPanel {
        private JTree repositoryTree;
        private DefaultMutableTreeNode projectRootNode = new DefaultMutableTreeNode("root");
        private DefaultTreeModel treeModel = new DefaultTreeModel(this.projectRootNode);

        RepositoryPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.repositoryTree = new JTree(this.treeModel);
            this.repositoryTree.setRowHeight(0);
            this.repositoryTree.setRootVisible(false);
            this.repositoryTree.setOpaque(false);
            this.repositoryTree.getSelectionModel().setSelectionMode(1);
            this.repositoryTree.expandRow(0);
            RepositorySelectorRenderer renderer = new RepositorySelectorRenderer();
            renderer.setOpenIcon(GoogleCloudToolsIcons.CLOUD);
            renderer.setClosedIcon(GoogleCloudToolsIcons.CLOUD);
            renderer.setLeafIcon(null);
            this.repositoryTree.setCellRenderer(renderer);
            this.repositoryTree.addTreeSelectionListener(event -> {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.repositoryTree.getLastSelectedPathComponent();
                if (node != null && node instanceof RepositoryModelItem) {
                    RepositoryModelItem repoNode = (RepositoryModelItem)node;
                    RepositorySelector.this.setText(repoNode.getRepositoryId());
                    ApplicationManager.getApplication().invokeLater(RepositorySelector.this::hidePopup);
                }
            });
            JBScrollPane scrollPane = new JBScrollPane();
            scrollPane.setPreferredSize(new Dimension(RepositorySelector.this.getPopupWidth(), RepositorySelector.this.getPreferredPopupHeight()));
            scrollPane.setViewportView((Component)this.repositoryTree);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)scrollPane);
            JPanel bottomPane = new JPanel();
            JPanel buttonPanel = new JPanel();
            bottomPane.setLayout(new BorderLayout());
            bottomPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            if (RepositorySelector.this.canCreateRepository) {
                JButton newRepositoryButton = new JButton();
                newRepositoryButton.setText(GctBundle.message("cloud.repository.selector.create.button", new Object[0]));
                newRepositoryButton.addActionListener(event -> {
                    try {
                        Desktop.getDesktop().browse(URI.create(RepositorySelector.PANETHEON_CREATE_REPO_URL_PREFIX + RepositorySelector.this.cloudProject));
                    }
                    catch (IOException e) {
                        logger.error(GctBundle.message("cloud.repository.selector.create.url.error", new Object[0]));
                    }
                });
                buttonPanel.add(newRepositoryButton);
            }
            JButton refreshButton = new JButton();
            refreshButton.setIcon(GoogleCloudToolsIcons.REFRESH);
            refreshButton.addActionListener(event -> this.refresh());
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(refreshButton);
            bottomPane.add((Component)buttonPanel, "Last");
            this.add(bottomPane);
            this.refresh();
        }

        private void refresh() {
            if (RepositorySelector.this.repositories == null) {
                RepositorySelector.this.repositories = new ProjectRepositoriesModelItem();
            }
            this.setLoader();
            RepositorySelector.this.loadRepositories(() -> ApplicationManager.getApplication().invokeAndWait(() -> {
                this.treeModel.insertNodeInto(RepositorySelector.this.repositories, this.projectRootNode, 0);
                this.treeModel.reload();
                this.repositoryTree.expandRow(0);
            }, ModalityState.stateForComponent((Component)RepositorySelector.this)));
        }

        private void setLoader() {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                RepositorySelector.this.repositories.removeAllChildren();
                RepositorySelector.this.repositories.add(new ResourceLoadingModelItem());
                this.treeModel.insertNodeInto(RepositorySelector.this.repositories, this.projectRootNode, 0);
                this.treeModel.reload();
                this.repositoryTree.expandRow(0);
            }, ModalityState.defaultModalityState());
        }

        @VisibleForTesting
        public DefaultTreeModel getTreeModel() {
            return this.treeModel;
        }
    }

    @VisibleForTesting
    public class ProjectNotSelectedPanel
    extends JPanel {
        private static final int HEIGHT = 30;

        ProjectNotSelectedPanel() {
            this.setPreferredSize(new Dimension(RepositorySelector.this.getTextField().getWidth(), 30));
            JBLabel warning = new JBLabel();
            warning.setFont(new Font(this.getFont().getFontName(), 2, this.getFont().getSize()));
            warning.setText(GctBundle.message("cloud.repository.selector.missing.project.error", new Object[0]));
            this.add((Component)warning);
        }
    }
}

