/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.resources;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.model.ListProjectsResponse;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.gct.idea.resources.ResourceErrorModelItem;
import com.google.gct.idea.resources.ResourceLoadingModelItem;
import com.google.gct.idea.resources.ResourceNewProjectModelItem;
import com.google.gct.idea.resources.ResourceProjectModelItem;
import com.google.gct.login.CredentialedUser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

class GoogleUserModelItem
extends DefaultMutableTreeNode {
    private static final Logger LOG = Logger.getInstance(GoogleUserModelItem.class);
    private static final String PROJECT_DELETE_REQUESTED = "DELETE_REQUESTED";
    private final CredentialedUser myUser;
    private final DefaultTreeModel myTreeModel;
    private volatile boolean myIsSynchronizing;
    private volatile boolean myNeedsSynchronizing;

    GoogleUserModelItem(@NotNull CredentialedUser user, @NotNull DefaultTreeModel treeModel) {
        this.myUser = user;
        this.myTreeModel = treeModel;
        this.setNeedsSynchronizing();
    }

    public CredentialedUser getCredentialedUser() {
        return this.myUser;
    }

    public Image getImage() {
        return this.myUser.getPicture();
    }

    public String getName() {
        return this.myUser.getName();
    }

    public String getEmail() {
        return this.myUser.getEmail();
    }

    public void setNeedsSynchronizing() {
        this.myNeedsSynchronizing = true;
        this.removeAllChildren();
        this.add(new ResourceLoadingModelItem());
        this.myTreeModel.reload(this);
    }

    public void synchronize() {
        if (!this.myNeedsSynchronizing || this.myIsSynchronizing) {
            return;
        }
        this.myIsSynchronizing = true;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    GoogleUserModelItem.this.loadUserProjects(GoogleUserModelItem.this.myUser);
                    GoogleUserModelItem.this.myNeedsSynchronizing = false;
                }
                finally {
                    GoogleUserModelItem.this.myIsSynchronizing = false;
                }
            }
        });
    }

    public boolean isSynchronizing() {
        return this.myIsSynchronizing;
    }

    private void loadErrorState(final @NotNull Exception ex) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleUserModelItem.this.removeAllChildren();
                GoogleUserModelItem.this.add(new ResourceErrorModelItem("Error: " + ex.toString()));
                GoogleUserModelItem.this.myTreeModel.reload(GoogleUserModelItem.this);
            }
        });
    }

    private void loadUserProjects(CredentialedUser user) {
        final ArrayList<DefaultMutableTreeNode> result = new ArrayList<DefaultMutableTreeNode>();
        CloudResourceManager cloudResourceManagerClient = new CloudResourceManager.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)user.getCredential()).setApplicationName("Android Studio").build();
        try {
            ListProjectsResponse response = (ListProjectsResponse)cloudResourceManagerClient.projects().list().setPageSize(Integer.valueOf(300)).execute();
            if (response != null && response.getProjects() != null) {
                for (Project pantheonProject : response.getProjects()) {
                    if (Strings.isNullOrEmpty((String)pantheonProject.getProjectId()) || PROJECT_DELETE_REQUESTED.equals(pantheonProject.getLifecycleState())) continue;
                    result.add(new ResourceProjectModelItem(pantheonProject));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception loading projects for " + this.myUser.getName(), (Throwable)e);
            this.loadErrorState(e);
            return;
        }
        result.add(new ResourceNewProjectModelItem());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GoogleUserModelItem.this.removeAllChildren();
                    for (DefaultMutableTreeNode item : result) {
                        GoogleUserModelItem.this.add(item);
                    }
                    GoogleUserModelItem.this.myTreeModel.reload(GoogleUserModelItem.this);
                }
            });
        }
        catch (InterruptedException ex) {
            LOG.error("InterruptedException loading projects for " + this.myUser.getName(), (Throwable)ex);
            this.loadErrorState(ex);
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException ex) {
            LOG.error("InvocationTargetException loading projects for " + this.myUser.getName(), (Throwable)ex);
            this.loadErrorState(ex);
        }
    }
}

