/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.gct.idea.debugger.CloudDebugRunConfiguration;
import com.google.gct.idea.debugger.CloudLineBreakpointProperties;
import com.google.gct.idea.debugger.ui.BreakpointConfigurationPanel;
import com.google.gct.idea.util.GctBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import icons.GoogleCloudToolsIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class CloudLineBreakpointType
extends XLineBreakpointType<CloudLineBreakpointProperties>
implements JavaBreakpointType,
Disposable {
    public CloudLineBreakpointType() {
        super("cloud-snapshotlocation", GctBundle.getString("clouddebug.breakpoint.description", new Object[0]));
    }

    public static CloudLineBreakpointType getInstance() {
        return (CloudLineBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CloudLineBreakpointType.class));
    }

    public final boolean canPutAt(@NotNull VirtualFile file, final int line, @NotNull Project project) {
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)project);
        if (runManager.getSelectedConfiguration() == null || !(runManager.getSelectedConfiguration().getConfiguration() instanceof CloudDebugRunConfiguration)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || psiFile.getVirtualFile().getFileType() == XHtmlFileType.INSTANCE) {
            return false;
        }
        if (!JavaClassFileType.INSTANCE.equals(psiFile.getFileType()) && !DebuggerUtils.isBreakpointAware((PsiFile)psiFile)) {
            return false;
        }
        final Document document = FileDocumentManager.getInstance().getDocument(file);
        final Ref result = Ref.create();
        assert (document != null);
        XDebuggerUtil.getInstance().iterateLine(project, document, line, (Processor)new Processor<PsiElement>(){

            public boolean process(PsiElement element) {
                if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                    return true;
                }
                PsiElement parent = element;
                while (element != null) {
                    if (element instanceof PsiModifierList) {
                        element = element.getParent();
                        continue;
                    }
                    int offset = element.getTextOffset();
                    if (offset >= 0 && document.getLineNumber(offset) != line) break;
                    parent = element;
                    element = element.getParent();
                }
                if (parent instanceof PsiMethod) {
                    PsiStatement[] statements;
                    PsiCodeBlock body;
                    if (parent.getTextRange().getEndOffset() >= document.getLineEndOffset(line) && (body = ((PsiMethod)parent).getBody()) != null && (statements = body.getStatements()).length > 0 && document.getLineNumber(statements[0].getTextOffset()) == line) {
                        result.set(CloudLineBreakpointType.class);
                    }
                } else {
                    result.set(CloudLineBreakpointType.class);
                }
                return true;
            }
        });
        return result.get() == ((Object)((Object)this)).getClass();
    }

    @Nullable
    public CloudLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        return new CloudLineBreakpointProperties();
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<CloudLineBreakpointProperties>> createCustomPropertiesPanel() {
        return new BreakpointConfigurationPanel(this);
    }

    @NotNull
    public Breakpoint createJavaBreakpoint(Project project, XBreakpoint breakpoint) {
        CloudLineBreakpoint lineBreakpoint = new CloudLineBreakpoint(project, breakpoint);
        lineBreakpoint.init();
        return lineBreakpoint;
    }

    @Nullable
    public CloudLineBreakpointProperties createProperties() {
        return new CloudLineBreakpointProperties();
    }

    public void dispose() {
    }

    @NotNull
    public Icon getDisabledIcon() {
        return GoogleCloudToolsIcons.CLOUD_BREAKPOINT_DISABLED;
    }

    @Nullable
    public final XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<CloudLineBreakpointProperties> breakpoint, @NotNull Project project) {
        return new JavaDebuggerEditorsProvider();
    }

    @NotNull
    public Icon getEnabledIcon() {
        return GoogleCloudToolsIcons.CLOUD_BREAKPOINT;
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<CloudLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    public int getPriority() {
        return 101;
    }

    public boolean isAddBreakpointButtonVisible() {
        return false;
    }

    public final boolean isSuspendThreadSupported() {
        return false;
    }

    public static class CloudLineBreakpoint
    extends LineBreakpoint {
        private String myErrorMessage = null;
        private boolean myIsVerified = false;

        public CloudLineBreakpoint(Project project, XBreakpoint xBreakpoint) {
            super(project, xBreakpoint);
        }

        protected Icon getDisabledIcon(boolean isMuted) {
            return GoogleCloudToolsIcons.CLOUD_BREAKPOINT_DISABLED;
        }

        public String getErrorMessage() {
            return this.myErrorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.myErrorMessage = errorMessage;
        }

        protected Icon getSetIcon(boolean isMuted) {
            if (!Strings.isNullOrEmpty((String)this.myErrorMessage)) {
                return GoogleCloudToolsIcons.CLOUD_BREAKPOINT_ERROR;
            }
            if (this.myIsVerified) {
                return GoogleCloudToolsIcons.CLOUD_BREAKPOINT_CHECKED;
            }
            return GoogleCloudToolsIcons.CLOUD_BREAKPOINT;
        }

        @Nullable
        public List<String> getWatchExpressions() {
            CloudLineBreakpointProperties properties = (CloudLineBreakpointProperties)this.getXBreakpoint().getProperties();
            if (properties.getWatchExpressions() != null && properties.getWatchExpressions().length > 0) {
                return Arrays.asList(properties.getWatchExpressions());
            }
            return null;
        }

        public boolean hasError() {
            return !Strings.isNullOrEmpty((String)this.getErrorMessage());
        }

        public void setVerified(boolean isVerified) {
            this.myIsVerified = isVerified;
        }
    }
}

