/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.common.collect.Maps;
import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedResourceInspection
extends EndpointInspectionBase {
    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("named.resource.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return EndpointBundle.message("named.resource.name", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return EndpointBundle.message("named.resource.short.name", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new EndpointPsiElementVisitor(){

            public void visitMethod(PsiMethod psiMethod) {
                if (!EndpointUtilities.isEndpointClass((PsiElement)psiMethod)) {
                    return;
                }
                if (this.hasTransformer((PsiElement)psiMethod)) {
                    return;
                }
                if (!EndpointUtilities.isApiMethod(psiMethod)) {
                    return;
                }
                PsiParameterList parameterList = psiMethod.getParameterList();
                HashMap methodNames = Maps.newHashMap();
                for (PsiParameter aParameter : parameterList.getParameters()) {
                    this.validateMethodNameUnique(aParameter, methodNames);
                }
            }

            private void validateMethodNameUnique(PsiParameter psiParameter, Map<String, PsiParameter> methodNames) {
                PsiModifierList modifierList = psiParameter.getModifierList();
                if (modifierList == null) {
                    return;
                }
                PsiAnnotation annotation = modifierList.findAnnotation("javax.inject.Named");
                if (annotation == null && (annotation = modifierList.findAnnotation("com.google.api.server.spi.config.Named")) == null) {
                    return;
                }
                PsiNameValuePair[] nameValuePairs = annotation.getParameterList().getAttributes();
                if (nameValuePairs.length == 0) {
                    holder.registerProblem((PsiElement)annotation, "Parameter name must be specified.", new LocalQuickFix[]{new MissingNameQuickFix()});
                    return;
                }
                if (nameValuePairs.length != 1) {
                    return;
                }
                if (nameValuePairs[0] == null) {
                    return;
                }
                PsiAnnotationMemberValue memberValue = nameValuePairs[0].getValue();
                if (memberValue == null) {
                    return;
                }
                String nameValueWithQuotes = memberValue.getText();
                String nameValue = EndpointUtilities.removeBeginningAndEndingQuotes(nameValueWithQuotes);
                if (nameValue.isEmpty()) {
                    holder.registerProblem((PsiElement)annotation, "Parameter name must be specified.", new LocalQuickFix[]{new MissingNameQuickFix()});
                    return;
                }
                PsiParameter seenParameter = methodNames.get(nameValue);
                if (seenParameter == null) {
                    methodNames.put(nameValue, psiParameter);
                } else {
                    holder.registerProblem((PsiElement)annotation, "Duplicate parameter name: " + nameValue + ". Parameter names must be unique.", new LocalQuickFix[]{new DuplicateNameQuickFix()});
                }
            }
        };
    }

    public class MissingNameQuickFix
    implements LocalQuickFix {
        private final String DEFAULT_PARAMETER_NAME = "myName";

        @NotNull
        public String getName() {
            return this.getFamilyName() + ": Add name";
        }

        @NotNull
        public String getFamilyName() {
            return NamedResourceInspection.this.getDisplayName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement annotationParent;
            PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return;
            }
            if (!(element instanceof PsiAnnotation)) {
                return;
            }
            PsiAnnotation annotation = (PsiAnnotation)element;
            if (!annotation.getQualifiedName().equals("javax.inject.Named") && !annotation.getQualifiedName().equals("com.google.api.server.spi.config.Named")) {
                return;
            }
            String nameValue = "myName";
            PsiElement modifierList = annotation.getParent();
            if (modifierList != null && (annotationParent = modifierList.getParent()) instanceof PsiParameter) {
                nameValue = ((PsiParameter)annotationParent).getName();
            }
            String newNamedValue = "@Named(\"" + nameValue + "\")";
            PsiAnnotation newAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(newNamedValue, null);
            assert (newAnnotation.getParameterList().getAttributes().length == 1);
            annotation.getParameterList().replace((PsiElement)newAnnotation.getParameterList());
        }
    }

    public class DuplicateNameQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return this.getFamilyName() + ": Rename duplicate parameter";
        }

        @NotNull
        public String getFamilyName() {
            return NamedResourceInspection.this.getDisplayName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element == null) {
                return;
            }
            if (!(element instanceof PsiAnnotation)) {
                return;
            }
            PsiAnnotation annotation = (PsiAnnotation)element;
            if (!annotation.getQualifiedName().equals("javax.inject.Named") && !annotation.getQualifiedName().equals("com.google.api.server.spi.config.Named")) {
                return;
            }
            PsiNameValuePair[] nameValuePairs = annotation.getParameterList().getAttributes();
            if (nameValuePairs.length == 0) {
                return;
            }
            PsiAnnotationMemberValue memberValue = nameValuePairs[0].getValue();
            if (memberValue == null) {
                return;
            }
            String newNamedValue = "@Named(\"" + EndpointUtilities.removeBeginningAndEndingQuotes(memberValue.getText()) + "_1\")";
            PsiAnnotation newAnnotation = JavaPsiFacade.getInstance((Project)project).getElementFactory().createAnnotationFromText(newNamedValue, null);
            assert (newAnnotation.getParameterList().getAttributes().length == 1);
            memberValue.replace((PsiElement)newAnnotation.getParameterList().getAttributes()[0].getValue());
        }
    }

    public static enum Error {
        MISSING_NAME,
        DUPLICATE_PARAMETER;

    }
}

