/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import com.intellij.junit5.JUnit5TestExecutionListener;
import com.intellij.junit5.JUnit5TestRunnerUtil;
import com.intellij.rt.execution.junit.IDEAJUnitListener;
import com.intellij.rt.execution.junit.IDEAJUnitListenerEx;
import com.intellij.rt.junit.IdeaTestRunner;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherFactory;

public class JUnit5IdeaTestRunner
implements IdeaTestRunner<TestIdentifier> {
    private final List<JUnit5TestExecutionListener> myExecutionListeners = new ArrayList<JUnit5TestExecutionListener>();
    private ArrayList<String> myListeners;
    private Launcher myLauncher;
    private TestPlan myForkedTestPlan;
    private static final TestIdentifier FAKE_ROOT = TestIdentifier.from((TestDescriptor)new EngineDescriptor(UniqueId.forEngine((String)"FAKE_ENGINE"), "FAKE ENGINE"));

    public void createListeners(ArrayList<String> listeners, int count) {
        this.myListeners = listeners;
        do {
            JUnit5TestExecutionListener currentListener = new JUnit5TestExecutionListener();
            this.myExecutionListeners.add(currentListener);
            if (count <= 2) continue;
            currentListener.initializeIdSuffix(count);
        } while (--count > 0);
        this.myLauncher = LauncherFactory.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startRunnerWithArgs(String[] args, String name, int count, boolean sendTree) {
        try {
            JUnit5TestExecutionListener listener = this.myExecutionListeners.get(0);
            listener.initializeIdSuffix(!sendTree);
            String[] packageNameRef = new String[1];
            LauncherDiscoveryRequest discoveryRequest = JUnit5TestRunnerUtil.buildRequest(args, packageNameRef);
            ArrayList<Object> listeners = new ArrayList<Object>();
            listeners.add(listener);
            for (String listenerClassName : this.myListeners) {
                IDEAJUnitListener junitListener = (IDEAJUnitListener)Class.forName(listenerClassName).newInstance();
                listeners.add(new MyCustomListenerWrapper(junitListener));
            }
            if (sendTree) {
                for (JUnit5TestExecutionListener executionListener : this.myExecutionListeners) {
                    executionListener.setRootName(packageNameRef[0]);
                    executionListener.setSendTree();
                }
            }
            this.myLauncher.execute(discoveryRequest, listeners.toArray(new TestExecutionListener[0]));
            int n = listener.wasSuccessful() ? 0 : -1;
            return n;
        }
        catch (Exception e) {
            System.err.println("Internal Error occurred.");
            e.printStackTrace(System.err);
            int n = -2;
            return n;
        }
        finally {
            if (count > 0) {
                this.myExecutionListeners.remove(0);
            }
        }
    }

    public TestIdentifier getTestToStart(String[] args, String name) {
        LauncherDiscoveryRequest discoveryRequest = JUnit5TestRunnerUtil.buildRequest(args, new String[1]);
        this.myForkedTestPlan = LauncherFactory.create().discover(discoveryRequest);
        Set roots = this.myForkedTestPlan.getRoots();
        if (roots.isEmpty()) {
            return null;
        }
        List nonEmptyRoots = roots.stream().filter(identifier -> !this.myForkedTestPlan.getChildren(identifier).isEmpty()).collect(Collectors.toList());
        if (nonEmptyRoots.isEmpty()) {
            return null;
        }
        return nonEmptyRoots.size() == 1 ? (TestIdentifier)nonEmptyRoots.get(0) : FAKE_ROOT;
    }

    public List<TestIdentifier> getChildTests(TestIdentifier description) {
        if (description == FAKE_ROOT) {
            return this.myForkedTestPlan.getRoots().stream().flatMap(root -> this.myForkedTestPlan.getChildren(root).stream()).collect(Collectors.toList());
        }
        return new ArrayList<TestIdentifier>(this.myForkedTestPlan.getChildren(description));
    }

    public String getStartDescription(TestIdentifier child) {
        if (!this.myForkedTestPlan.getParent(child).isPresent()) {
            child = (TestIdentifier)this.myForkedTestPlan.getChildren(child).iterator().next();
        }
        TestIdentifier testIdentifier = child;
        String className = JUnit5TestExecutionListener.getClassName(testIdentifier);
        String methodSignature = JUnit5TestExecutionListener.getMethodSignature(testIdentifier);
        if (methodSignature != null) {
            return className + "," + methodSignature;
        }
        return className != null ? className : testIdentifier.getDisplayName();
    }

    public String getTestClassName(TestIdentifier child) {
        return child.toString();
    }

    private static class MyCustomListenerWrapper
    implements TestExecutionListener {
        private final IDEAJUnitListener myJunitListener;

        MyCustomListenerWrapper(IDEAJUnitListener junitListener) {
            this.myJunitListener = junitListener;
        }

        public void executionStarted(TestIdentifier testIdentifier) {
            if (testIdentifier.isTest()) {
                String className = JUnit5TestExecutionListener.getClassName(testIdentifier);
                String methodName = JUnit5TestExecutionListener.getMethodName(testIdentifier);
                this.myJunitListener.testStarted(className, methodName);
            }
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            if (testIdentifier.isTest()) {
                String className = JUnit5TestExecutionListener.getClassName(testIdentifier);
                String methodName = JUnit5TestExecutionListener.getMethodName(testIdentifier);
                if (this.myJunitListener instanceof IDEAJUnitListenerEx) {
                    ((IDEAJUnitListenerEx)this.myJunitListener).testFinished(className, methodName, testExecutionResult.getStatus() == TestExecutionResult.Status.SUCCESSFUL);
                } else {
                    this.myJunitListener.testFinished(className, methodName);
                }
            }
        }
    }
}

