/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.SdkConstants;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolListVisitor;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolTableBuilder;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u001a$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e\u001a\u001e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001eH\u0002\u001a\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0017\u001a6\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020&0*2\u0006\u0010+\u001a\u00020&2\b\b\u0002\u0010,\u001a\u00020-\u001a\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0/2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u00100\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0017\u001a\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\u0006\u00102\u001a\u00020\u0017\u001a\u0016\u00103\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0001\u001a\u001c\u00107\u001a\u00020\u00192\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0001092\u0006\u0010:\u001a\u00020;\u001a\u000e\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u0001\u001a\u000e\u0010>\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"ANDROID_UNDERSCORE_PREFIX", "", "KEEP_RULE_PREFIX", "KEEP_RULE_SUFFIX", "NORMALIZED_VALUE_NAME_CHARS", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "VALUE_ID_SPLITTER", "Lcom/google/common/base/Splitter;", "canonicalizeValueResourceName", "name", "failParseArrayLiteral", "", "size", "", "valuesString", "generateKeepRules", "", "manifest", "Lcom/android/ide/common/xml/ManifestData;", "isMainDex", "", "mergedResources", "Ljava/io/File;", "generateKeepRulesFromLayoutXmlFile", "", "layout", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "rules", "Ljava/util/SortedSet;", "generateKeepRulesFromXmlNode", "node", "Lorg/w3c/dom/Element;", "generateMinifyKeepRules", "getPackageNameFromManifest", "manifestFile", "mergeAndRenumberSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "mainPackageName", "librarySymbols", "dependencySymbols", "", "platformSymbols", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "parseArrayLiteral", "Lcom/google/common/collect/ImmutableList;", "parseManifest", "parseMinifiedKeepRules", "proguardRulesFile", "rTxtToSymbolTable", "inputStream", "Ljava/io/InputStream;", "packageName", "readAarRTxt", "lines", "", "visitor", "Lcom/android/ide/common/symbols/SymbolListVisitor;", "valueStringToInt", "valueString", "visitEmptySymbolTable", "android.sdktools.sdk-common"})
@JvmName(name="SymbolUtils")
public final class SymbolUtils {
    private static final CharMatcher NORMALIZED_VALUE_NAME_CHARS = CharMatcher.anyOf((CharSequence)".:").precomputed();
    private static final String ANDROID_UNDERSCORE_PREFIX = "android_";
    private static final String KEEP_RULE_PREFIX = "-keep class ";
    private static final String KEEP_RULE_SUFFIX = " { <init>(...); }";
    private static final Splitter VALUE_ID_SPLITTER = Splitter.on((char)',').trimResults();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SymbolTable mergeAndRenumberSymbols(@NotNull String mainPackageName, @NotNull SymbolTable librarySymbols, @NotNull Collection<? extends SymbolTable> dependencySymbols, @NotNull SymbolTable platformSymbols, @NotNull IdProvider idProvider) {
        ArrayList<? extends SymbolTable> tables = new ArrayList<SymbolTable>(dependencySymbols.size() + 1);
        tables.add(librarySymbols);
        tables.addAll(dependencySymbols);
        HashMultimap newSymbolMap = HashMultimap.create();
        HashMap arrayToAttrs = new HashMap();
        Iterable $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SymbolTable table = (SymbolTable)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)table.getSymbols().values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Symbol symbol = (Symbol)element$iv2;
                boolean bl2 = false;
                Symbol symbol2 = symbol;
                if (symbol2 instanceof Symbol.AttributeSymbol) {
                    newSymbolMap.put((Object)ResourceType.ATTR, (Object)symbol.getCanonicalName());
                    continue;
                }
                if (symbol2 instanceof Symbol.NormalSymbol) {
                    newSymbolMap.put((Object)symbol.getResourceType(), (Object)symbol.getCanonicalName());
                    continue;
                }
                if (symbol2 instanceof Symbol.StyleableSymbol) {
                    Object object;
                    void $this$getOrPut$iv;
                    Map map = arrayToAttrs;
                    String key$iv = symbol.getCanonicalName();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        Set answer$iv = new HashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).addAll((Collection)symbol.getChildren());
                    continue;
                }
                throw (Throwable)new IOException("Unexpected symbol " + symbol);
            }
        }
        SymbolTable.Builder tableBuilder = SymbolTable.Companion.builder().tablePackage(mainPackageName);
        HashMap attrToValue = new HashMap();
        for (ResourceType resourceType : newSymbolMap.keySet()) {
            ArrayList symbolNames = Lists.newArrayList((Iterable)newSymbolMap.get((Object)resourceType));
            CollectionsKt.sort((List)symbolNames);
            for (String symbolName : symbolNames) {
                int value = idProvider.next(resourceType);
                Symbol newSymbol = null;
                if (resourceType == ResourceType.ATTR) {
                    newSymbol = Symbol.Companion.attributeSymbol$default(Symbol.Companion, symbolName, value, false, null, null, 24, null);
                    ((Map)attrToValue).put(symbolName, newSymbol);
                } else {
                    int n = value;
                    ResourceVisibility resourceVisibility = null;
                    String string = symbolName;
                    newSymbol = Symbol.Companion.normalSymbol$default(Symbol.Companion, resourceType, symbolName, n, resourceVisibility, string, 8, null);
                }
                tableBuilder.add(newSymbol);
            }
        }
        arrayToAttrs.forEach((BiConsumer)new BiConsumer<String, Set<String>>(platformSymbols, attrToValue, tableBuilder){
            final /* synthetic */ SymbolTable $platformSymbols;
            final /* synthetic */ HashMap $attrToValue;
            final /* synthetic */ SymbolTable.Builder $tableBuilder;

            public final void accept(@NotNull String arrayName, @NotNull Set<String> children) {
                List attributes = CollectionsKt.sorted((Iterable)children);
                ImmutableList.Builder attributeValues = ImmutableList.builder();
                for (String attribute : attributes) {
                    Symbol.AttributeSymbol symbol;
                    if (StringsKt.startsWith$default((String)attribute, (String)"android:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)attribute, (String)"android_", (boolean)false, (int)2, null)) {
                        String name;
                        String string = attribute;
                        int n = SdkConstants.ANDROID_NS_NAME_PREFIX_LEN;
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                        Symbol platformSymbol = (Symbol)this.$platformSymbols.getSymbols().get((Object)ResourceType.ATTR, (Object)name);
                        if (platformSymbol != null) {
                            attributeValues.add((Object)platformSymbol.getIntValue());
                            continue;
                        }
                    }
                    if ((symbol = (Symbol.AttributeSymbol)this.$attrToValue.get(attribute)) != null) {
                        attributeValues.add((Object)symbol.getIntValue());
                        continue;
                    }
                    attributeValues.add((Object)0);
                }
                this.$tableBuilder.add(Symbol.Companion.styleableSymbol$default(Symbol.Companion, arrayName, attributeValues.build(), ImmutableList.copyOf((Collection)attributes), null, arrayName, 8, null));
            }
            {
                this.$platformSymbols = symbolTable;
                this.$attrToValue = hashMap;
                this.$tableBuilder = builder;
            }
        });
        return tableBuilder.build();
    }

    public static /* synthetic */ SymbolTable mergeAndRenumberSymbols$default(String string, SymbolTable symbolTable, Collection collection, SymbolTable symbolTable2, IdProvider idProvider, int n, Object object) {
        if ((n & 0x10) != 0) {
            idProvider = IdProvider.Companion.sequential();
        }
        return SymbolUtils.mergeAndRenumberSymbols(string, symbolTable, collection, symbolTable2, idProvider);
    }

    @NotNull
    public static final String getPackageNameFromManifest(@NotNull File manifestFile) throws IOException {
        ManifestData manifestData;
        try {
            manifestData = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (SAXException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath() + '\'', e);
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath() + '\'', e);
        }
        ManifestData manifestData2 = manifestData;
        return manifestData2.getPackage();
    }

    @NotNull
    public static final String getPackageNameFromManifest(@NotNull ManifestData manifest) {
        return manifest.getPackage();
    }

    @NotNull
    public static final Set<String> generateMinifyKeepRules(@NotNull ManifestData manifest, @Nullable File mergedResources) {
        return SymbolUtils.generateKeepRules(manifest, false, mergedResources);
    }

    @VisibleForTesting
    @NotNull
    public static final Set<String> generateKeepRules(@NotNull ManifestData manifest, boolean isMainDex, @Nullable File mergedResources) {
        SortedSet rules = SetsKt.sortedSetOf((Object[])new String[0]);
        rules.add("# Generated by the gradle plugin");
        ManifestData.KeepClass[] keepClassArray = manifest.getKeepClasses();
        int n = keepClassArray.length;
        for (int i = 0; i < n; ++i) {
            ManifestData.KeepClass keepClass = keepClassArray[i];
            if (isMainDex) {
                String type = keepClass.getType();
                String process = keepClass.getProcess();
                if (Intrinsics.areEqual((Object)type, (Object)"activity") || Intrinsics.areEqual((Object)type, (Object)"service") || Intrinsics.areEqual((Object)type, (Object)"provider") || Intrinsics.areEqual((Object)type, (Object)"receiver")) {
                    if (process == null) continue;
                    CharSequence charSequence = process;
                    int n2 = 0;
                    if (charSequence.length() == 0 || StringsKt.startsWith$default((String)process, (String)":", (boolean)false, (int)2, null)) continue;
                }
            }
            rules.add(KEEP_RULE_PREFIX + keepClass.getName() + KEEP_RULE_SUFFIX);
        }
        if (mergedResources != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                for (File typeDir : mergedResources.listFiles()) {
                    if (!typeDir.isDirectory() || !StringsKt.startsWith$default((String)typeDir.getName(), (String)"layout", (boolean)false, (int)2, null)) continue;
                    for (File layoutXml : typeDir.listFiles()) {
                        if (!layoutXml.isFile()) continue;
                        SymbolUtils.generateKeepRulesFromLayoutXmlFile(layoutXml, documentBuilder, rules);
                    }
                }
            }
            catch (ParserConfigurationException e) {
                throw (Throwable)new IOException("Failed to read merged resources", e);
            }
        }
        return rules;
    }

    public static final void generateKeepRulesFromLayoutXmlFile(@NotNull File layout, @NotNull DocumentBuilder documentBuilder, @NotNull SortedSet<String> rules) throws IOException {
        try {
            Document xmlDocument = documentBuilder.parse(layout);
            Element root = xmlDocument.getDocumentElement();
            if (root != null) {
                SymbolUtils.generateKeepRulesFromXmlNode(root, rules);
            }
        }
        catch (SAXException e) {
            throw (Throwable)new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e);
        }
    }

    private static final void generateKeepRulesFromXmlNode(Element node, SortedSet<String> rules) {
        String tag = node.getTagName();
        if (StringsKt.contains$default((CharSequence)tag, (CharSequence)".", (boolean)false, (int)2, null)) {
            rules.add(KEEP_RULE_PREFIX + tag + KEEP_RULE_SUFFIX);
        }
        for (Node current = node.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeType() != 1) continue;
            SymbolUtils.generateKeepRulesFromXmlNode((Element)current, rules);
        }
    }

    @NotNull
    public static final SortedSet<String> parseMinifiedKeepRules(@NotNull File proguardRulesFile) throws IOException {
        TreeSet keepClasses = SetsKt.sortedSetOf((Object[])new String[0]);
        if (!proguardRulesFile.isFile()) {
            throw (Throwable)new IOException("Failed to parse proguard rules at path: " + proguardRulesFile.getAbsolutePath());
        }
        FilesKt.forEachLine$default((File)proguardRulesFile, null, (Function1)((Function1)new Function1<String, Unit>(keepClasses){
            final /* synthetic */ TreeSet $keepClasses;

            public final void invoke(@NotNull String it) {
                if (StringsKt.startsWith$default((String)it, (String)"-keep class ", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)" { <init>(...); }", (boolean)false, (int)2, null)) {
                    this.$keepClasses.add(it);
                }
            }
            {
                this.$keepClasses = treeSet;
                super(1);
            }
        }), (int)1, null);
        return keepClasses;
    }

    @NotNull
    public static final ManifestData parseManifest(@NotNull File manifestFile) throws IOException {
        ManifestData manifestData;
        try {
            manifestData = AndroidManifestParser.parse((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (SAXException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw (Throwable)new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e);
        }
        return manifestData;
    }

    @NotNull
    public static final String canonicalizeValueResourceName(@NotNull String name) {
        return NORMALIZED_VALUE_NAME_CHARS.replaceFrom((CharSequence)name, '_');
    }

    public static final int valueStringToInt(@NotNull String valueString) {
        int n;
        if (StringsKt.startsWith$default((String)valueString, (String)"0x", (boolean)false, (int)2, null)) {
            String string = valueString;
            int n2 = 2;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            n = Integer.parseUnsignedInt(string3, 16);
        } else {
            n = Integer.parseInt(valueString);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ImmutableList<Integer> parseArrayLiteral(int size, @NotNull String valuesString) {
        if (size == 0) {
            if (!StringsKt.isBlank((CharSequence)valuesString.subSequence(1, valuesString.length() - 1))) {
                Void void_ = SymbolUtils.failParseArrayLiteral(size, valuesString);
                throw null;
            }
            return ImmutableList.of();
        }
        ImmutableList.Builder ints = ImmutableList.builder();
        Iterator values = VALUE_ID_SPLITTER.split(valuesString.subSequence(1, valuesString.length() - 1)).iterator();
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            if (!values.hasNext()) {
                Void void_ = SymbolUtils.failParseArrayLiteral(size, valuesString);
                throw null;
            }
            ints.add((Object)SymbolUtils.valueStringToInt((String)values.next()));
            ++i;
        }
        if (values.hasNext()) {
            Void void_ = SymbolUtils.failParseArrayLiteral(size, valuesString);
            throw null;
        }
        return ints.build();
    }

    @NotNull
    public static final Void failParseArrayLiteral(int size, @NotNull String valuesString) {
        throw (Throwable)new IOException("Values string " + valuesString + " should have " + size + " item(s).");
    }

    public static final void readAarRTxt(@NotNull Iterator<String> lines, @NotNull SymbolListVisitor visitor) throws IOException {
        visitor.visit();
        String styleableChildPrefix = null;
        while (lines.hasNext()) {
            int end;
            int middle;
            int start;
            String line = lines.next();
            if (styleableChildPrefix != null && StringsKt.startsWith$default((String)line, (String)styleableChildPrefix, (boolean)false, (int)2, null)) {
                start = styleableChildPrefix.length() + 1;
                int end2 = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)styleableChildPrefix.length(), (boolean)false, (int)4, null);
                if (end2 == -1) continue;
                String string = line;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(start, end2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                visitor.child(string3);
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"int styleable ", (boolean)false, (int)2, null) || (start = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)0, (boolean)false, (int)6, null) + 1) == 0 || (middle = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)start, (boolean)false, (int)4, null) + 1) == 0 || (end = StringsKt.indexOf$default((CharSequence)line, (char)' ', (int)middle, (boolean)false, (int)4, null) + 1) == 0) continue;
            visitor.symbol(line.subSequence(start, middle - 1), line.subSequence(middle, end - 1));
            if (StringsKt.startsWith$default((String)line, (String)"int[] ", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append("int styleable ");
                String string = line;
                int n = end - 1;
                boolean bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(middle, n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                styleableChildPrefix = stringBuilder.append(string5).toString();
                continue;
            }
            styleableChildPrefix = null;
        }
        visitor.visitEnd();
    }

    public static final void visitEmptySymbolTable(@NotNull SymbolListVisitor visitor) {
        visitor.visit();
        visitor.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SymbolTable rTxtToSymbolTable(@NotNull InputStream inputStream, @NotNull String packageName) {
        SymbolTableBuilder symbolTableBuilder = new SymbolTableBuilder(packageName);
        Closeable closeable = inputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable closeable2 = closeable;
        int n = 0;
        closeable2 = new InputStreamReader((InputStream)closeable2, charset);
        n = 8192;
        boolean bl2 = false;
        closeable = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n);
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl4 = false;
            SymbolUtils.readAarRTxt(it.lines().iterator(), symbolTableBuilder);
            closeable2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return symbolTableBuilder.getSymbolTable();
    }
}

