/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.usage;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceId;
import com.android.ide.common.resources.usage.ResourceStore;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 :2\u00020\u0001:\u0001:B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nJ\u0006\u0010$\u001a\u00020\u0007J\u0006\u0010%\u001a\u00020\u0007J\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u0007J\u0010\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020!J\"\u0010(\u001a\u0004\u0018\u00010\n2\b\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0007J\u0018\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u001f0.J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0007J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\n002\u0006\u00101\u001a\u00020\u0007H\u0002J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u00103\u001a\u00020\u0007J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u00105\u001a\u00020\u0007J\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002072\u0006\u0010)\u001a\u00020\u0007J\u000e\u00109\u001a\u0002072\u0006\u0010)\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR&\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u001f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\n0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/android/ide/common/resources/usage/ResourceStore;", "", "supportMultipackages", "", "(Z)V", "_discardAttributes", "", "", "_keepAttributes", "_resources", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "discardAttributes", "", "getDiscardAttributes", "()Ljava/util/List;", "keepAttributes", "getKeepAttributes", "keepResources", "", "Lcom/android/ide/common/resources/usage/ResourceId;", "resourceById", "", "resources", "getResources", "safeMode", "getSafeMode", "()Z", "setSafeMode", "getSupportMultipackages", "typeToName", "Lcom/android/resources/ResourceType;", "Lcom/google/common/collect/ListMultimap;", "valueToResource", "", "addResource", "resource", "dumpConfig", "dumpKeepResources", "dumpReferences", "dumpResourceModel", "getResource", "value", "packageName", "type", "name", "getResourceMaps", "", "getResourcesForKeepOrDiscardPatter", "Lkotlin/sequences/Sequence;", "pattern", "getResourcesFromUrl", "possibleUrlReference", "getResourcesFromWebUrl", "webUrl", "processToolsAttributes", "", "recordDiscardToolAttribute", "recordKeepToolAttribute", "Companion", "android.sdktools.sdk-common"})
public final class ResourceStore {
    private final Map<ResourceId, ResourceUsageModel.Resource> resourceById;
    private final List<ResourceUsageModel.Resource> _resources;
    private final Map<ResourceType, ListMultimap<String, ResourceUsageModel.Resource>> typeToName;
    private final Map<Integer, ResourceUsageModel.Resource> valueToResource;
    private final Set<ResourceId> keepResources;
    private final List<String> _keepAttributes;
    private final List<String> _discardAttributes;
    private boolean safeMode;
    private final boolean supportMultipackages;
    private static final int TYPICAL_RESOURCE_COUNT = 200;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<ResourceUsageModel.Resource> getResources() {
        return Collections.unmodifiableList(this._resources);
    }

    @NotNull
    public final List<String> getKeepAttributes() {
        return Collections.unmodifiableList(this._keepAttributes);
    }

    @NotNull
    public final List<String> getDiscardAttributes() {
        return Collections.unmodifiableList(this._discardAttributes);
    }

    public final boolean getSafeMode() {
        return this.safeMode;
    }

    public final void setSafeMode(boolean bl) {
        this.safeMode = bl;
    }

    @Nullable
    public final ResourceUsageModel.Resource getResource(int value) {
        return this.valueToResource.get(value);
    }

    @Nullable
    public final ResourceUsageModel.Resource getResource(@Nullable String packageName, @NotNull ResourceType type, @NotNull String name) {
        Preconditions.checkArgument((this.supportMultipackages || packageName == null ? 1 : 0) != 0, (String)"In a single package mode packageName must be null.", (Object[])new Object[0]);
        return this.resourceById.get(new ResourceId(type, name, packageName));
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResources(@NotNull ResourceType type, @NotNull String name) {
        ListMultimap<String, ResourceUsageModel.Resource> listMultimap = this.typeToName.get(type);
        if (listMultimap == null) {
            return CollectionsKt.emptyList();
        }
        ListMultimap<String, ResourceUsageModel.Resource> resourcesByName = listMultimap;
        return CollectionsKt.toList((Iterable)resourcesByName.get((Object)ResourcesUtil.resourceNameToFieldName(name)));
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResourcesFromUrl(@NotNull String possibleUrlReference) {
        ResourceUrl url = ResourceUrl.parse((String)possibleUrlReference);
        if (url == null || url.isFramework()) {
            return CollectionsKt.emptyList();
        }
        return this.getResources(url.type, url.name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceUsageModel.Resource> getResourcesFromWebUrl(@NotNull String webUrl) {
        void $this$flatMapTo$iv$iv;
        void type;
        List list;
        String afterAndroidRes = StringsKt.substringAfter$default((String)webUrl, (String)"android_res/", null, (int)2, null);
        List parts = StringsKt.split$default((CharSequence)afterAndroidRes, (String[])new String[]{"/"}, (boolean)false, (int)2, (int)2, null);
        if (parts.size() < 2) {
            return CollectionsKt.emptyList();
        }
        List list2 = list = parts;
        boolean bl = false;
        String string = (String)list2.get(0);
        list2 = list;
        bl = false;
        String namePart = (String)list2.get(1);
        ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType((String)type);
        if (resourceFolderType == null) {
            return CollectionsKt.emptyList();
        }
        ResourceFolderType folderType = resourceFolderType;
        String name = StringsKt.substringBefore$default((String)namePart, (char)'.', null, (int)2, null);
        Iterable $this$flatMap$iv = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ResourceType it = (ResourceType)element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = this.getResources(it, name);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ResourceUsageModel.Resource addResource(@NotNull ResourceUsageModel.Resource resource) {
        ResourceUsageModel.Resource resource2;
        boolean bl;
        Map<Integer, ResourceUsageModel.Resource> map;
        ResourceId id;
        ResourceUsageModel.Resource stored;
        if (!this.supportMultipackages) {
            resource.packageName = null;
        }
        if ((stored = this.resourceById.get(id = new ResourceId(resource.type, resource.name, resource.packageName))) == null) {
            map = this.resourceById;
            Pair pair = TuplesKt.to((Object)id, (Object)resource);
            bl = false;
            map.put((Integer)((Object)((ResourceId)pair.getFirst())), (ResourceUsageModel.Resource)pair.getSecond());
            map = this._resources;
            boolean bl2 = false;
            map.add(resource);
            this.typeToName.computeIfAbsent(resource.type, addResource.updated.1.INSTANCE).put((Object)resource.name, (Object)resource);
            if (resource.value != -1) {
                map = this.valueToResource;
                Pair pair2 = TuplesKt.to((Object)resource.value, (Object)resource);
                bl = false;
                map.put((Integer)pair2.getFirst(), (ResourceUsageModel.Resource)pair2.getSecond());
            }
            resource2 = resource;
        } else {
            Preconditions.checkState((resource.value == -1 || stored.value == resource.value ? 1 : 0) != 0, (String)"Resource value must be the same between addResource calls.", (Object[])new Object[0]);
            if (resource.value != -1 && stored.value == -1) {
                stored.value = resource.value;
                map = this.valueToResource;
                Pair pair = TuplesKt.to((Object)stored.value, (Object)stored);
                bl = false;
                map.put((Integer)pair.getFirst(), (ResourceUsageModel.Resource)pair.getSecond());
            }
            resource2 = stored;
        }
        ResourceUsageModel.Resource updated2 = resource2;
        return updated2;
    }

    @NotNull
    public final Collection<ListMultimap<String, ResourceUsageModel.Resource>> getResourceMaps() {
        return this.typeToName.values();
    }

    public final void recordKeepToolAttribute(@NotNull String value) {
        Iterable $this$forEach$iv = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Collection collection = this._keepAttributes;
            boolean bl2 = false;
            collection.add(it);
        }
    }

    public final void recordDiscardToolAttribute(@NotNull String value) {
        Iterable $this$forEach$iv = Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)value);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Collection collection = this._discardAttributes;
            boolean bl2 = false;
            collection.add(it);
        }
    }

    public final void processToolsAttributes() {
        ResourceUsageModel.Resource it;
        Sequence $this$forEach$iv = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this._keepAttributes), (Function1)((Function1)new Function1<String, Sequence<? extends ResourceUsageModel.Resource>>(this){
            final /* synthetic */ ResourceStore this$0;

            @NotNull
            public final Sequence<ResourceUsageModel.Resource> invoke(@NotNull String it) {
                return ResourceStore.access$getResourcesForKeepOrDiscardPatter(this.this$0, it);
            }
            {
                this.this$0 = resourceStore;
                super(1);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            it.setReachable(true);
            Collection collection = this.keepResources;
            ResourceId resourceId = new ResourceId(it.type, it.name, it.packageName);
            boolean bl2 = false;
            collection.add(resourceId);
        }
        $this$forEach$iv = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this._discardAttributes), (Function1)((Function1)new Function1<String, Sequence<? extends ResourceUsageModel.Resource>>(this){
            final /* synthetic */ ResourceStore this$0;

            @NotNull
            public final Sequence<ResourceUsageModel.Resource> invoke(@NotNull String it) {
                return ResourceStore.access$getResourcesForKeepOrDiscardPatter(this.this$0, it);
            }
            {
                this.this$0 = resourceStore;
                super(1);
            }
        }));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ResourceUsageModel.Resource)element$iv;
            boolean bl = false;
            it.setReachable(false);
        }
    }

    @NotNull
    public final String dumpConfig() {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)this._resources), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{dumpConfig.1.INSTANCE, dumpConfig.2.INSTANCE})), (Function1)((Function1)new Function1<ResourceUsageModel.Resource, String>(this){
            final /* synthetic */ ResourceStore this$0;

            @NotNull
            public final String invoke(@NotNull ResourceUsageModel.Resource r) {
                Object[] objectArray;
                ResourceId id = new ResourceId(r.type, r.name, r.packageName);
                String string = "remove";
                boolean bl = false;
                boolean bl2 = false;
                String string2 = string;
                int n = 0;
                Object[] objectArray2 = objectArray = new String[2];
                boolean bl3 = false;
                boolean bl4 = r.isReachable();
                objectArray[n] = !bl4 ? string : null;
                string = "no_obfuscate";
                bl = false;
                bl2 = false;
                String it = string;
                n = 1;
                objectArray = objectArray2;
                boolean bl5 = false;
                bl4 = ResourceStore.access$getKeepResources$p(this.this$0).contains(id);
                objectArray[n] = bl4 ? string : null;
                String actions = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                return r.type + '/' + r.name + '#' + actions;
            }
            {
                this.this$0 = resourceStore;
                super(1);
            }
        })), (CharSequence)"\n", (CharSequence)"", (CharSequence)"\n", (int)0, null, null, (int)56, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dumpKeepResources() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.keepResources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceId resourceId = (ResourceId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String dumpReferences() {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this._resources), (Function1)dumpReferences.1.INSTANCE), (Function1)dumpReferences.2.INSTANCE), (CharSequence)"\n", (CharSequence)"Resource Reference Graph:\n", (CharSequence)"", (int)0, null, null, (int)56, null);
    }

    @NotNull
    public final String dumpResourceModel() {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)this._resources), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{dumpResourceModel.1.INSTANCE, dumpResourceModel.2.INSTANCE})), (Function1)dumpResourceModel.3.INSTANCE), (CharSequence)"\n", (CharSequence)"", (CharSequence)"\n", (int)0, null, null, (int)56, null);
    }

    private final Sequence<ResourceUsageModel.Resource> getResourcesForKeepOrDiscardPatter(String pattern) {
        Sequence sequence;
        ResourceUrl url = ResourceUrl.parse((String)pattern);
        if (url == null || url.isFramework()) {
            return SequencesKt.emptySequence();
        }
        ListMultimap<String, ResourceUsageModel.Resource> listMultimap = this.typeToName.get(url.type);
        if (listMultimap == null) {
            return SequencesKt.emptySequence();
        }
        ListMultimap<String, ResourceUsageModel.Resource> resources = listMultimap;
        if (!StringsKt.contains$default((CharSequence)url.name, (CharSequence)"*", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)url.name, (CharSequence)"?", (boolean)false, (int)2, null)) {
            return CollectionsKt.asSequence((Iterable)resources.get((Object)url.name));
        }
        try {
            String string = SdkUtils.globToRegexp((String)ResourcesUtil.resourceNameToFieldName(url.name));
            boolean bl = false;
            Regex regexp = new Regex(string);
            sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)resources.entries()), (Function1)((Function1)new Function1<Map.Entry<String, ResourceUsageModel.Resource>, Boolean>(regexp){
                final /* synthetic */ Regex $regexp;

                public final boolean invoke(Map.Entry<String, ResourceUsageModel.Resource> it) {
                    return this.$regexp.matches((CharSequence)it.getKey());
                }
                {
                    this.$regexp = regex;
                    super(1);
                }
            })), (Function1)getResourcesForKeepOrDiscardPatter.2.INSTANCE);
        }
        catch (PatternSyntaxException e) {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    public final boolean getSupportMultipackages() {
        return this.supportMultipackages;
    }

    public ResourceStore(boolean supportMultipackages) {
        this.supportMultipackages = supportMultipackages;
        this.resourceById = Maps.newLinkedHashMapWithExpectedSize((int)200);
        this._resources = Lists.newArrayListWithCapacity((int)200);
        this.typeToName = Maps.newEnumMap(ResourceType.class);
        this.valueToResource = Maps.newHashMapWithExpectedSize((int)200);
        this.keepResources = Sets.newHashSet();
        this._keepAttributes = Lists.newArrayList();
        this._discardAttributes = Lists.newArrayList();
        this.safeMode = true;
    }

    public /* synthetic */ ResourceStore(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public ResourceStore() {
        this(false, 1, null);
    }

    public static final /* synthetic */ Sequence access$getResourcesForKeepOrDiscardPatter(ResourceStore $this, String pattern) {
        return $this.getResourcesForKeepOrDiscardPatter(pattern);
    }

    public static final /* synthetic */ Set access$getKeepResources$p(ResourceStore $this) {
        return $this.keepResources;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/ide/common/resources/usage/ResourceStore$Companion;", "", "()V", "TYPICAL_RESOURCE_COUNT", "", "android.sdktools.sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

