/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.HierarchicalElement;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.AdapterUtils;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalGradleProject;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaContentRoot;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaJavaLanguageSettings;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaProject;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalProjectIdentifier;
import org.jetbrains.plugins.gradle.tooling.util.GradleContainerUtil;

public class InternalIdeaModule
implements IdeaModule {
    private String name;
    private String description;
    private InternalIdeaProject parent;
    private Set<InternalIdeaContentRoot> contentRoots = GradleContainerUtil.emptyDomainObjectSet();
    private List<InternalIdeaDependency> dependencies = new LinkedList<InternalIdeaDependency>();
    private InternalGradleProject gradleProject;
    private InternalIdeaCompilerOutput compilerOutput;
    private InternalIdeaJavaLanguageSettings javaLanguageSettings;
    private String jdkName;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ImmutableDomainObjectSet<InternalIdeaContentRoot> getContentRoots() {
        return AdapterUtils.wrap(this.contentRoots);
    }

    public void setContentRoots(List<InternalIdeaContentRoot> contentRoots) {
        this.contentRoots = ImmutableDomainObjectSet.of(contentRoots);
    }

    public InternalIdeaProject getParent() {
        return this.parent;
    }

    public InternalIdeaProject getProject() {
        return this.parent;
    }

    public void setParent(InternalIdeaProject parent) {
        this.parent = parent;
    }

    public DomainObjectSet<InternalIdeaDependency> getDependencies() {
        return ImmutableDomainObjectSet.of(this.dependencies);
    }

    public void setDependencies(List<InternalIdeaDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public DomainObjectSet<? extends HierarchicalElement> getChildren() {
        return ImmutableDomainObjectSet.of(Collections.emptySet());
    }

    public InternalGradleProject getGradleProject() {
        return this.gradleProject;
    }

    public void setGradleProject(InternalGradleProject gradleProject) {
        this.gradleProject = gradleProject;
    }

    public IdeaCompilerOutput getCompilerOutput() {
        return this.compilerOutput;
    }

    public void setCompilerOutput(InternalIdeaCompilerOutput compilerOutput) {
        this.compilerOutput = compilerOutput;
    }

    public InternalIdeaJavaLanguageSettings getJavaLanguageSettings() {
        return this.javaLanguageSettings;
    }

    public void setJavaLanguageSettings(InternalIdeaJavaLanguageSettings javaLanguageSettings) {
        this.javaLanguageSettings = javaLanguageSettings;
    }

    public String getJdkName() {
        return this.jdkName;
    }

    public void setJdkName(String jdkName) {
        this.jdkName = jdkName;
    }

    public InternalProjectIdentifier getProjectIdentifier() {
        return this.gradleProject.getProjectIdentifier();
    }

    public String getProjectPath() {
        return this.getProjectIdentifier().getProjectPath();
    }

    public File getRootDir() {
        return this.getProjectIdentifier().getBuildIdentifier().getRootDir();
    }

    public String toString() {
        return "IdeaModule{name='" + this.name + '\'' + ", gradleProject='" + this.gradleProject + '\'' + ", contentRoots=" + this.contentRoots + ", compilerOutput=" + this.compilerOutput + ", dependencies count=" + this.dependencies.size() + '}';
    }
}

