/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.Exceptions;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.AdapterUtils;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalIdeaSourceDirectory;
import org.jetbrains.plugins.gradle.tooling.util.GradleContainerUtil;
import org.jetbrains.plugins.gradle.tooling.util.GradleVersionComparator;

public class InternalIdeaContentRoot
implements IdeaContentRoot {
    private File rootDirectory;
    private Set<InternalIdeaSourceDirectory> sourceDirectories = GradleContainerUtil.emptyDomainObjectSet();
    private Set<InternalIdeaSourceDirectory> testDirectories = GradleContainerUtil.emptyDomainObjectSet();
    private Set<InternalIdeaSourceDirectory> resourceDirectories = GradleContainerUtil.emptyDomainObjectSet();
    private Set<InternalIdeaSourceDirectory> testResourceDirectories = GradleContainerUtil.emptyDomainObjectSet();
    private Set<File> excludeDirectories = new LinkedHashSet<File>();
    private final GradleVersionComparator myGradleVersionComparator;

    public InternalIdeaContentRoot(@NotNull GradleVersionComparator gradleVersionComparator) {
        this.myGradleVersionComparator = gradleVersionComparator;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public ImmutableDomainObjectSet<InternalIdeaSourceDirectory> getSourceDirectories() {
        return AdapterUtils.wrap(this.sourceDirectories);
    }

    public void setSourceDirectories(Set<InternalIdeaSourceDirectory> sourceDirectories) {
        this.sourceDirectories = ImmutableDomainObjectSet.of(sourceDirectories);
    }

    public ImmutableDomainObjectSet<InternalIdeaSourceDirectory> getGeneratedSourceDirectories() {
        return ImmutableDomainObjectSet.of(InternalIdeaContentRoot.generated(this.sourceDirectories));
    }

    public ImmutableDomainObjectSet<InternalIdeaSourceDirectory> getTestDirectories() {
        return AdapterUtils.wrap(this.testDirectories);
    }

    public void setTestDirectories(Set<InternalIdeaSourceDirectory> testDirectories) {
        this.testDirectories = ImmutableDomainObjectSet.of(testDirectories);
    }

    public ImmutableDomainObjectSet<InternalIdeaSourceDirectory> getGeneratedTestDirectories() {
        return ImmutableDomainObjectSet.of(InternalIdeaContentRoot.generated(this.testDirectories));
    }

    public ImmutableDomainObjectSet<InternalIdeaSourceDirectory> getResourceDirectories() {
        if (this.myGradleVersionComparator.lessThan("4.7")) {
            throw Exceptions.unsupportedMethod("IdeaContentRoot.getResourceDirectories()");
        }
        return AdapterUtils.wrap(this.resourceDirectories);
    }

    public void setResourceDirectories(Set<InternalIdeaSourceDirectory> resourceDirectories) {
        this.resourceDirectories = ImmutableDomainObjectSet.of(resourceDirectories);
    }

    public ImmutableDomainObjectSet<InternalIdeaSourceDirectory> getTestResourceDirectories() {
        if (this.myGradleVersionComparator.lessThan("4.7")) {
            throw Exceptions.unsupportedMethod("IdeaContentRoot.getTestResourceDirectories()");
        }
        return AdapterUtils.wrap(this.testResourceDirectories);
    }

    public void setTestResourceDirectories(Set<InternalIdeaSourceDirectory> testResourceDirectories) {
        this.testResourceDirectories = ImmutableDomainObjectSet.of(testResourceDirectories);
    }

    public Set<File> getExcludeDirectories() {
        return this.excludeDirectories;
    }

    public void setExcludeDirectories(Set<File> excludeDirectories) {
        this.excludeDirectories = excludeDirectories;
    }

    private static Set<InternalIdeaSourceDirectory> generated(Set<InternalIdeaSourceDirectory> directories) {
        LinkedHashSet<InternalIdeaSourceDirectory> generated = new LinkedHashSet<InternalIdeaSourceDirectory>();
        for (InternalIdeaSourceDirectory sourceDirectory : directories) {
            if (!sourceDirectory.isGenerated()) continue;
            generated.add(sourceDirectory);
        }
        return generated;
    }

    public String toString() {
        return String.format("IdeaContentRoot{rootDirectory=%s, sourceDirectories count=%d, testDirectories count=%d, resourceDirectories count=%d, testResourceDirectories count=%d, excludeDirectories count=%d}", this.rootDirectory, this.sourceDirectories.size(), this.testDirectories.size(), this.resourceDirectories.size(), this.testResourceDirectories.size(), this.excludeDirectories.size());
    }
}

