/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.artifacts.ArtifactOutputToSourceMapping;
import org.jetbrains.jps.incremental.artifacts.impl.DependentJarsEvaluator;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactPathUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.ExplodedDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.FileBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.JarBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;

public class JarsBuilder {
    private static final Logger LOG = Logger.getInstance(JarsBuilder.class);
    private final Set<JarInfo> myJarsToBuild;
    private final CompileContext myContext;
    private Map<JarInfo, File> myBuiltJars;
    private final BuildOutputConsumer myOutputConsumer;
    private final ArtifactOutputToSourceMapping myOutSrcMapping;

    public JarsBuilder(Set<JarInfo> jarsToBuild, CompileContext context, BuildOutputConsumer outputConsumer, ArtifactOutputToSourceMapping outSrcMapping) {
        this.myOutputConsumer = outputConsumer;
        this.myOutSrcMapping = outSrcMapping;
        DependentJarsEvaluator evaluator = new DependentJarsEvaluator();
        for (JarInfo jarInfo : jarsToBuild) {
            evaluator.addJarWithDependencies(jarInfo);
        }
        this.myJarsToBuild = evaluator.getJars();
        this.myContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildJars() throws IOException, ProjectBuildException {
        this.myContext.processMessage(new ProgressMessage("Building archives..."));
        JarInfo[] sortedJars = this.sortJars();
        if (sortedJars == null) {
            return false;
        }
        this.myBuiltJars = new HashMap<JarInfo, File>();
        try {
            for (JarInfo jar : sortedJars) {
                this.myContext.checkCanceled();
                this.buildJar(jar);
            }
            this.myContext.processMessage(new ProgressMessage("Copying archives..."));
            this.copyJars();
        }
        finally {
            this.deleteTemporaryJars();
        }
        return true;
    }

    private void deleteTemporaryJars() {
        for (File file : this.myBuiltJars.values()) {
            FileUtil.delete((File)file);
        }
    }

    private void copyJars() throws IOException {
        for (Map.Entry<JarInfo, File> entry : this.myBuiltJars.entrySet()) {
            File fromFile = entry.getValue();
            JarInfo jarInfo = entry.getKey();
            DestinationInfo destination = jarInfo.getDestination();
            if (!(destination instanceof ExplodedDestinationInfo)) continue;
            File toFile = new File(FileUtil.toSystemDependentName((String)destination.getOutputPath()));
            FileUtil.rename((File)fromFile, (File)toFile);
        }
    }

    private JarInfo @Nullable [] sortJars() {
        DFSTBuilder builder = new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new JarsGraph())));
        if (!builder.isAcyclic()) {
            Couple dependency = builder.getCircularDependency();
            String message = "Cannot build: circular dependency found between '" + ((JarInfo)dependency.getFirst()).getPresentableDestination() + "' and '" + ((JarInfo)dependency.getSecond()).getPresentableDestination() + "'";
            this.myContext.processMessage(new CompilerMessage("Artifacts builder", BuildMessage.Kind.ERROR, message));
            return null;
        }
        Object[] jars = this.myJarsToBuild.toArray(new JarInfo[0]);
        Arrays.sort(jars, builder.comparator());
        jars = (JarInfo[])ArrayUtil.reverseArray((Object[])jars);
        return jars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildJar(JarInfo jar) throws IOException {
        String emptyArchiveMessage = "Archive '" + jar.getPresentableDestination() + "' doesn't contain files so it won't be created";
        if (jar.getContent().isEmpty()) {
            this.myContext.processMessage(new CompilerMessage("Artifacts builder", BuildMessage.Kind.WARNING, emptyArchiveMessage));
            return;
        }
        this.myContext.processMessage(new ProgressMessage("Building " + jar.getPresentableDestination() + "..."));
        File jarFile = FileUtil.createTempFile((String)"artifactCompiler", (String)"tmp");
        this.myBuiltJars.put(jar, jarFile);
        FileUtil.createParentDirs((File)jarFile);
        String targetJarPath = jar.getDestination().getOutputFilePath();
        ArrayList<String> packedFilePaths = new ArrayList<String>();
        Manifest manifest = this.loadManifest(jar, packedFilePaths);
        JarOutputStream jarOutputStream = JarsBuilder.createJarOutputStream(jarFile, manifest);
        THashSet writtenPaths = new THashSet();
        try {
            if (manifest != null) {
                writtenPaths.add((Object)"META-INF/MANIFEST.MF");
            }
            for (Pair<String, Object> pair : jar.getContent()) {
                String relativePath = (String)pair.getFirst();
                if (pair.getSecond() instanceof ArtifactRootDescriptor) {
                    ArtifactRootDescriptor descriptor = (ArtifactRootDescriptor)pair.getSecond();
                    int rootIndex = descriptor.getRootIndex();
                    if (descriptor instanceof FileBasedArtifactRootDescriptor) {
                        this.addFileToJar(jarOutputStream, jarFile, descriptor.getRootFile(), descriptor.getFilter(), relativePath, targetJarPath, (Set<? super String>)writtenPaths, packedFilePaths, rootIndex);
                        continue;
                    }
                    String filePath = FileUtil.toSystemIndependentName((String)descriptor.getRootFile().getAbsolutePath());
                    packedFilePaths.add(filePath);
                    this.myOutSrcMapping.appendData(targetJarPath, rootIndex, filePath);
                    this.extractFileAndAddToJar(jarOutputStream, (JarBasedArtifactRootDescriptor)descriptor, relativePath, (Set<? super String>)writtenPaths);
                    continue;
                }
                JarInfo nestedJar = (JarInfo)pair.getSecond();
                File nestedJarFile = this.myBuiltJars.get(nestedJar);
                if (nestedJarFile != null) {
                    this.addFileToJar(jarOutputStream, jarFile, nestedJarFile, SourceFileFilter.ALL, relativePath, targetJarPath, (Set<? super String>)writtenPaths, packedFilePaths, -1);
                    continue;
                }
                LOG.debug("nested JAR file " + relativePath + " for " + jar.getPresentableDestination() + " not found");
            }
            if (writtenPaths.isEmpty()) {
                this.myContext.processMessage(new CompilerMessage("Artifacts builder", BuildMessage.Kind.WARNING, emptyArchiveMessage));
                return;
            }
            ProjectBuilderLogger logger = this.myContext.getLoggingManager().getProjectBuilderLogger();
            if (logger.isEnabled()) {
                logger.logCompiledPaths(packedFilePaths, "Artifacts builder", "Packing files:");
            }
            this.myOutputConsumer.registerOutputFile(new File(targetJarPath), packedFilePaths);
        }
        finally {
            if (writtenPaths.isEmpty()) {
                try {
                    jarOutputStream.close();
                }
                catch (IOException iOException) {}
                FileUtil.delete((File)jarFile);
                this.myBuiltJars.remove(jar);
            } else {
                try {
                    jarOutputStream.close();
                }
                catch (IOException e) {
                    String messageText = "Cannot create '" + jar.getPresentableDestination() + "': " + e.getMessage();
                    this.myContext.processMessage(new CompilerMessage("Artifacts builder", BuildMessage.Kind.ERROR, messageText));
                    LOG.debug((Throwable)e);
                }
            }
        }
    }

    private static JarOutputStream createJarOutputStream(File jarFile, @Nullable Manifest manifest) throws IOException {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(jarFile));
        if (manifest != null) {
            return new JarOutputStream((OutputStream)outputStream, manifest);
        }
        return new JarOutputStream(outputStream);
    }

    @Nullable
    private Manifest loadManifest(JarInfo jar, List<? super String> packedFilePaths) throws IOException {
        for (Pair<String, Object> pair : jar.getContent()) {
            String rootPath;
            if (!(pair.getSecond() instanceof ArtifactRootDescriptor) || !"META-INF/MANIFEST.MF".startsWith(rootPath = (String)pair.getFirst())) continue;
            final String manifestPath = JpsArtifactPathUtil.trimForwardSlashes("META-INF/MANIFEST.MF".substring(rootPath.length()));
            final ArtifactRootDescriptor descriptor = (ArtifactRootDescriptor)pair.getSecond();
            if (descriptor instanceof FileBasedArtifactRootDescriptor) {
                File manifestFile = new File(descriptor.getRootFile(), manifestPath);
                if (!manifestFile.exists()) continue;
                String fullManifestPath = FileUtil.toSystemIndependentName((String)manifestFile.getAbsolutePath());
                packedFilePaths.add(fullManifestPath);
                try (FileInputStream stream = new FileInputStream(manifestFile);){
                    Manifest manifest = this.createManifest(stream, manifestFile);
                    return manifest;
                }
            }
            final Ref manifestRef = Ref.create(null);
            ((JarBasedArtifactRootDescriptor)descriptor).processEntries(new JarBasedArtifactRootDescriptor.EntryProcessor(){

                @Override
                public void process(@Nullable InputStream inputStream, @NotNull String relativePath, ZipEntry entry) throws IOException {
                    if (manifestRef.isNull() && relativePath.equals(manifestPath) && inputStream != null) {
                        try (InputStream stream = inputStream;){
                            manifestRef.set((Object)JarsBuilder.this.createManifest(stream, descriptor.getRootFile()));
                        }
                    }
                }
            });
            if (manifestRef.isNull()) continue;
            return (Manifest)manifestRef.get();
        }
        return null;
    }

    @Nullable
    private Manifest createManifest(InputStream manifestStream, File manifestFile) {
        try {
            return new Manifest(manifestStream);
        }
        catch (IOException e) {
            this.myContext.processMessage(new CompilerMessage("Artifacts builder", BuildMessage.Kind.ERROR, "Cannot create MANIFEST.MF from " + manifestFile.getAbsolutePath() + ":" + e.getMessage()));
            LOG.debug((Throwable)e);
            return null;
        }
    }

    private void extractFileAndAddToJar(final JarOutputStream jarOutputStream, final JarBasedArtifactRootDescriptor root, final String relativeOutputPath, final Set<? super String> writtenPaths) throws IOException {
        final long timestamp = FSOperations.lastModified(root.getRootFile());
        root.processEntries(new JarBasedArtifactRootDescriptor.EntryProcessor(){

            @Override
            public void process(@Nullable InputStream inputStream, @NotNull String relativePath, ZipEntry entry) throws IOException {
                String pathInJar = JarsBuilder.addParentDirectories(jarOutputStream, writtenPaths, JpsArtifactPathUtil.appendToPath(relativeOutputPath, relativePath));
                if (inputStream == null) {
                    if (!pathInJar.endsWith("/")) {
                        JarsBuilder.addDirectoryEntry(jarOutputStream, pathInJar + "/", writtenPaths);
                    }
                } else if (writtenPaths.add(pathInJar)) {
                    ZipEntry newEntry = new ZipEntry(pathInJar);
                    newEntry.setTime(timestamp);
                    if (entry.getMethod() == 0) {
                        newEntry.setMethod(0);
                        newEntry.setSize(entry.getSize());
                        newEntry.setCrc(entry.getCrc());
                    }
                    jarOutputStream.putNextEntry(newEntry);
                    FileUtil.copy((InputStream)inputStream, (OutputStream)jarOutputStream);
                    try {
                        jarOutputStream.closeEntry();
                    }
                    catch (IOException e) {
                        String messageText = "Cannot extract '" + pathInJar + "' from '" + root.getRootFile().getAbsolutePath() + "' while building '" + root.getTarget().getArtifact().getName() + "' artifact: " + e.getMessage();
                        JarsBuilder.this.myContext.processMessage(new CompilerMessage("Artifacts builder", BuildMessage.Kind.ERROR, messageText));
                        LOG.debug((Throwable)e);
                    }
                }
            }
        });
    }

    private void addFileToJar(@NotNull JarOutputStream jarOutputStream, @NotNull File jarFile, @NotNull File file, SourceFileFilter filter, @NotNull String relativePath, String targetJarPath, @NotNull Set<? super String> writtenPaths, List<? super String> packedFilePaths, int rootIndex) throws IOException {
        if (!file.exists() || FileUtil.isAncestor((File)file, (File)jarFile, (boolean)false)) {
            return;
        }
        relativePath = JarsBuilder.addParentDirectories(jarOutputStream, writtenPaths, relativePath);
        this.addFileOrDirRecursively(jarOutputStream, file, filter, relativePath, targetJarPath, writtenPaths, packedFilePaths, rootIndex);
    }

    private void addFileOrDirRecursively(@NotNull ZipOutputStream jarOutputStream, @NotNull File file, SourceFileFilter filter, @NotNull String relativePath, String targetJarPath, @NotNull Set<? super String> writtenItemRelativePaths, List<? super String> packedFilePaths, int rootIndex) throws IOException {
        String filePath = FileUtil.toSystemIndependentName((String)file.getAbsolutePath());
        if (!filter.accept(filePath) || !filter.shouldBeCopied(filePath, this.myContext.getProjectDescriptor())) {
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            String directoryPath;
            String string = directoryPath = relativePath.length() == 0 ? "" : relativePath + "/";
            if (!directoryPath.isEmpty()) {
                JarsBuilder.addDirectoryEntry(jarOutputStream, directoryPath, writtenItemRelativePaths);
            }
            if ((children = file.listFiles()) != null) {
                for (File child : children) {
                    this.addFileOrDirRecursively(jarOutputStream, child, filter, directoryPath + child.getName(), targetJarPath, writtenItemRelativePaths, packedFilePaths, rootIndex);
                }
            }
            return;
        }
        boolean added = ZipUtil.addFileToZip((ZipOutputStream)jarOutputStream, (File)file, (String)relativePath, writtenItemRelativePaths, null);
        if (rootIndex != -1) {
            this.myOutSrcMapping.appendData(targetJarPath, rootIndex, filePath);
            if (added) {
                packedFilePaths.add(filePath);
            }
        }
    }

    private static String addParentDirectories(JarOutputStream jarOutputStream, Set<? super String> writtenPaths, String relativePath) throws IOException {
        while (StringUtil.startsWithChar((CharSequence)relativePath, (char)'/')) {
            relativePath = relativePath.substring(1);
        }
        int i = relativePath.indexOf(47);
        while (i != -1) {
            String prefix = relativePath.substring(0, i + 1);
            if (prefix.length() > 1) {
                JarsBuilder.addDirectoryEntry(jarOutputStream, prefix, writtenPaths);
            }
            i = relativePath.indexOf(47, i + 1);
        }
        return relativePath;
    }

    private static void addDirectoryEntry(ZipOutputStream output, @NonNls String relativePath, Set<? super String> writtenPaths) throws IOException {
        if (!writtenPaths.add(relativePath)) {
            return;
        }
        ZipEntry e = new ZipEntry(relativePath);
        e.setMethod(0);
        e.setSize(0L);
        e.setCrc(0L);
        output.putNextEntry(e);
        output.closeEntry();
    }

    private class JarsGraph
    implements InboundSemiGraph<JarInfo> {
        private JarsGraph() {
        }

        @NotNull
        public Collection<JarInfo> getNodes() {
            return JarsBuilder.this.myJarsToBuild;
        }

        @NotNull
        public Iterator<JarInfo> getIn(JarInfo n) {
            HashSet<JarInfo> ins = new HashSet<JarInfo>();
            DestinationInfo destination = n.getDestination();
            if (destination instanceof JarDestinationInfo) {
                ins.add(((JarDestinationInfo)destination).getJarInfo());
            }
            return ins.iterator();
        }
    }
}

