/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.DifferenceImpl;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class ModuleRequiresRepr
extends Proto {
    private final int myVersion;

    public ModuleRequiresRepr(DependencyContext context, int access, int name, String version) {
        super(access, context.get(null), name, Collections.emptySet());
        this.myVersion = context.get(version);
    }

    public ModuleRequiresRepr(DependencyContext context, DataInput in) {
        super(context, in);
        try {
            this.myVersion = DataInputOutputUtil.readINT((DataInput)in);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public boolean isTransitive() {
        return (this.access & 0x20) != 0;
    }

    public int getVersion() {
        return this.myVersion;
    }

    @Override
    public void save(DataOutput out) {
        try {
            super.save(out);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myVersion);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    public static DataExternalizer<ModuleRequiresRepr> externalizer(final DependencyContext context) {
        return new DataExternalizer<ModuleRequiresRepr>(){

            public void save(@NotNull DataOutput out, ModuleRequiresRepr value) throws IOException {
                value.save(out);
            }

            public ModuleRequiresRepr read(@NotNull DataInput in) throws IOException {
                return new ModuleRequiresRepr(context, in);
            }
        };
    }

    @Override
    public Diff difference(Proto past) {
        final ModuleRequiresRepr pastRequirement = (ModuleRequiresRepr)past;
        return new Diff(super.difference(past)){

            @Override
            public boolean versionChanged() {
                return pastRequirement.myVersion != ModuleRequiresRepr.this.myVersion;
            }

            @Override
            public boolean no() {
                return super.no() && !this.versionChanged();
            }

            @Override
            public boolean becameNonTransitive() {
                return pastRequirement.isTransitive() && !ModuleRequiresRepr.this.isTransitive();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.name == ((ModuleRequiresRepr)o).name;
    }

    public int hashCode() {
        return 31 * this.name;
    }

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        stream.println("Requires module: " + context.getValue(this.name) + ":" + this.access + ":" + this.myVersion);
    }

    public static abstract class Diff
    extends DifferenceImpl {
        Diff(@NotNull Difference delegate) {
            super(delegate);
        }

        public abstract boolean versionChanged();

        public abstract boolean becameNonTransitive();
    }
}

