/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.DifferenceImpl;
import org.jetbrains.jps.builders.java.dependencyView.ParamAnnotation;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.ProtoMember;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.java.dependencyView.UsageRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.org.objectweb.asm.Type;

class MethodRepr
extends ProtoMember {
    public final Set<ParamAnnotation> myParameterAnnotations;
    public final TypeRepr.AbstractType[] myArgumentTypes;
    public final Set<TypeRepr.AbstractType> myExceptions;

    @Override
    public Diff difference(Proto past) {
        final MethodRepr m = (MethodRepr)past;
        Difference diff = super.difference(past);
        final Difference.Specifier excs = Difference.make(m.myExceptions, this.myExceptions);
        final Difference.Specifier paramAnnotations = Difference.make(m.myParameterAnnotations, this.myParameterAnnotations);
        final int base = paramAnnotations.unchanged() ? diff.base() : diff.base() | 0x40;
        return new Diff(diff){

            @Override
            public Difference.Specifier<ParamAnnotation, Difference> parameterAnnotations() {
                return paramAnnotations;
            }

            @Override
            public boolean no() {
                return this.base() == 0 && !this.defaultAdded() && !this.defaultRemoved() && excs.unchanged() && paramAnnotations.unchanged();
            }

            @Override
            public boolean defaultAdded() {
                return MethodRepr.this.hasValue() && !m.hasValue();
            }

            @Override
            public boolean defaultRemoved() {
                return !MethodRepr.this.hasValue() && m.hasValue();
            }

            @Override
            public Difference.Specifier<TypeRepr.AbstractType, Difference> exceptions() {
                return excs;
            }

            @Override
            public int base() {
                return base;
            }

            @Override
            public boolean hadValue() {
                return m.hasValue();
            }
        };
    }

    public void updateClassUsages(DependencyContext context, int owner, Set<? super UsageRepr.Usage> s) {
        this.myType.updateClassUsages(context, owner, s);
        for (TypeRepr.AbstractType argType : this.myArgumentTypes) {
            argType.updateClassUsages(context, owner, s);
        }
        if (this.myExceptions != null) {
            for (TypeRepr.AbstractType typ : this.myExceptions) {
                typ.updateClassUsages(context, owner, s);
            }
        }
    }

    public MethodRepr(DependencyContext context, int accessFlags, int name, int signature, String descriptor, Set<TypeRepr.ClassType> annotations, Set<ParamAnnotation> parameterAnnotations, String[] exceptions, Object defaultValue) {
        super(accessFlags, signature, name, TypeRepr.getType(context, Type.getReturnType((String)descriptor)), annotations, defaultValue);
        this.myParameterAnnotations = parameterAnnotations;
        THashSet typeCollection = exceptions != null ? new THashSet(exceptions.length) : Collections.emptySet();
        this.myExceptions = (Set)TypeRepr.createClassType(context, exceptions, (Collection<TypeRepr.AbstractType>)typeCollection);
        this.myArgumentTypes = TypeRepr.getType(context, Type.getArgumentTypes((String)descriptor));
    }

    MethodRepr(DependencyContext context, DataInput in) {
        super(context, in);
        try {
            DataExternalizer<TypeRepr.AbstractType> externalizer = TypeRepr.externalizer(context);
            int size = DataInputOutputUtil.readINT((DataInput)in);
            this.myArgumentTypes = RW.read(externalizer, in, new TypeRepr.AbstractType[size]);
            this.myExceptions = (Set)RW.read(externalizer, new THashSet(0), in);
            final DataExternalizer<TypeRepr.ClassType> clsTypeExternalizer = TypeRepr.classTypeExternalizer(context);
            this.myParameterAnnotations = (Set)RW.read(new DataExternalizer<ParamAnnotation>(){

                public void save(@NotNull DataOutput out, ParamAnnotation value) throws IOException {
                    value.save(out);
                }

                public ParamAnnotation read(@NotNull DataInput in) throws IOException {
                    return new ParamAnnotation((DataExternalizer<TypeRepr.ClassType>)clsTypeExternalizer, in);
                }
            }, new THashSet(), in);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void save(DataOutput out) {
        super.save(out);
        RW.save((RW.Savable[])this.myArgumentTypes, (DataOutput)out);
        RW.save(this.myExceptions, out);
        RW.save(this.myParameterAnnotations, out);
    }

    public static DataExternalizer<MethodRepr> externalizer(final DependencyContext context) {
        return new DataExternalizer<MethodRepr>(){

            public void save(@NotNull DataOutput out, MethodRepr value) throws IOException {
                value.save(out);
            }

            public MethodRepr read(@NotNull DataInput in) throws IOException {
                return new MethodRepr(context, in);
            }
        };
    }

    static Predicate equalByJavaRules(final MethodRepr me) {
        return new Predicate(){

            @Override
            public boolean satisfy(MethodRepr that) {
                if (me == that) {
                    return true;
                }
                return me.name == that.name && Arrays.equals(me.myArgumentTypes, that.myArgumentTypes);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodRepr that = (MethodRepr)o;
        return this.name == that.name && this.myType.equals(that.myType) && Arrays.equals(this.myArgumentTypes, that.myArgumentTypes);
    }

    public int hashCode() {
        return 31 * (31 * Arrays.hashCode(this.myArgumentTypes) + this.myType.hashCode()) + this.name;
    }

    private String getDescr(DependencyContext context) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (TypeRepr.AbstractType t : this.myArgumentTypes) {
            buf.append(t.getDescr(context));
        }
        buf.append(")");
        buf.append(this.myType.getDescr(context));
        return buf.toString();
    }

    public UsageRepr.Usage createUsage(DependencyContext context, int owner) {
        return UsageRepr.createMethodUsage(context, this.name, owner, this.getDescr(context));
    }

    public UsageRepr.Usage createMetaUsage(DependencyContext context, int owner) {
        return UsageRepr.createMetaMethodUsage(context, this.name, owner);
    }

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        super.toStream(context, stream);
        stream.print("          Arguments  : ");
        for (TypeRepr.AbstractType t : this.myArgumentTypes) {
            stream.print(t.getDescr(context));
            stream.print("; ");
        }
        stream.println();
        TypeRepr.AbstractType[] es = this.myExceptions.toArray(TypeRepr.AbstractType.EMPTY_TYPE_ARRAY);
        Arrays.sort(es, Comparator.comparing(o -> o.getDescr(context)));
        stream.print("          Exceptions : ");
        for (TypeRepr.AbstractType e : es) {
            stream.print(e.getDescr(context));
            stream.print("; ");
        }
        stream.println();
    }

    public static abstract class Diff
    extends DifferenceImpl {
        Diff(@NotNull Difference delegate) {
            super(delegate);
        }

        public abstract Difference.Specifier<ParamAnnotation, Difference> parameterAnnotations();

        public abstract Difference.Specifier<TypeRepr.AbstractType, Difference> exceptions();

        public abstract boolean defaultAdded();

        public abstract boolean defaultRemoved();
    }

    static interface Predicate {
        public boolean satisfy(MethodRepr var1);
    }
}

