/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class ResourcesTargetType
extends ModuleBasedBuildTargetType<ResourcesTarget> {
    public static final ResourcesTargetType PRODUCTION = new ResourcesTargetType("resources-production", false);
    public static final ResourcesTargetType TEST = new ResourcesTargetType("resources-test", true);
    public static final List<ResourcesTargetType> ALL_TYPES = ContainerUtil.immutableList((Object[])new ResourcesTargetType[]{PRODUCTION, TEST});
    private final boolean myTests;

    private ResourcesTargetType(String typeId, boolean tests) {
        super(typeId, true);
        this.myTests = tests;
    }

    @Override
    @NotNull
    public List<ResourcesTarget> computeAllTargets(@NotNull JpsModel model) {
        List modules = model.getProject().getModules();
        ArrayList<ResourcesTarget> targets = new ArrayList<ResourcesTarget>(modules.size());
        for (JpsModule module : modules) {
            targets.add(new ResourcesTarget(module, this));
        }
        return targets;
    }

    @NotNull
    public Loader createLoader(@NotNull JpsModel model) {
        return new Loader(model);
    }

    public boolean isTests() {
        return this.myTests;
    }

    public static ResourcesTargetType getInstance(boolean tests) {
        return tests ? TEST : PRODUCTION;
    }

    private class Loader
    extends BuildTargetLoader<ResourcesTarget> {
        private final Map<String, JpsModule> myModules = new HashMap<String, JpsModule>();

        Loader(JpsModel model) {
            for (JpsModule module : model.getProject().getModules()) {
                this.myModules.put(module.getName(), module);
            }
        }

        @Override
        @Nullable
        public ResourcesTarget createTarget(@NotNull String targetId) {
            JpsModule module = this.myModules.get(targetId);
            return module != null ? new ResourcesTarget(module, ResourcesTargetType.this) : null;
        }
    }
}

