/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitDependencyScopeSuggester
extends LibraryDependencyScopeSuggester {
    private static final String[] JUNIT_JAR_MARKERS = new String[]{"org.junit.Test", "junit.framework.TestCase", "org.hamcrest.Matcher", "org.hamcrest.Matchers", "org.junit.jupiter.api.Test", "org.junit.platform.commons.JUnitException", "org.opentest4j.AssertionFailedError"};

    @Nullable
    public DependencyScope getDefaultDependencyScope(@NotNull Library library) {
        long regularJars;
        VirtualFile[] files = library.getFiles(OrderRootType.CLASSES);
        long testJars = Arrays.stream(files).filter(JUnitDependencyScopeSuggester::isTestJarRoot).count();
        return testJars > (regularJars = (long)files.length - testJars) ? DependencyScope.TEST : null;
    }

    private static boolean isTestJarRoot(VirtualFile file) {
        for (String marker : JUNIT_JAR_MARKERS) {
            if (!LibraryUtil.isClassAvailableInLibrary(Collections.singletonList(file), (String)marker)) continue;
            return true;
        }
        return false;
    }
}

