/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JUnitBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JUnitConfigurationType
implements ConfigurationType {
    private final ConfigurationFactory myFactory = new ConfigurationFactory(this){

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            return new JUnitConfiguration("", project, (ConfigurationFactory)this);
        }

        @NotNull
        public String getId() {
            return "JUnit";
        }
    };

    @NotNull
    public String getDisplayName() {
        return JUnitBundle.message("junit.configuration.display.name", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return JUnitBundle.message("junit.configuration.description", new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.RunConfigurations.Junit;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.JUnit";
    }

    @NotNull
    public String getId() {
        return "JUnit";
    }

    @NotNull
    public String getTag() {
        String id = this.getId();
        return id.equals("JUnit") ? "junit" : id;
    }

    public boolean isDumbAware() {
        return true;
    }

    @NotNull
    public static JUnitConfigurationType getInstance() {
        return (JUnitConfigurationType)ConfigurationTypeUtil.findConfigurationType(JUnitConfigurationType.class);
    }
}

